/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.NewsFetcher;

public class ConfigUpdateHelper {
    private RouterContext _context;
    private static final long[] PERIODS = new long[]{43200000L, 86400000L, 172800000L, -1L};

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean updateAvailable() {
        return true;
    }

    public String getNewsURL() {
        String url = this._context.getProperty("router.newsURL");
        if (url != null) {
            return url;
        }
        return "http://complication.i2p/news.xml";
    }

    public String getUpdateURL() {
        String url = this._context.getProperty("router.updateURL");
        if (url != null) {
            return url;
        }
        return "http://echelon.i2p/i2p/i2pupdate.sud\r\nhttp://stats.i2p/i2p/i2pupdate.sud\r\nhttp://complication.i2p/i2p/i2pupdate.sud\r\nhttp://www.i2p2.i2p/_static/i2pupdate.sud\r\nhttp://update.postman.i2p/i2pupdate.sud";
    }

    public String getProxyHost() {
        String host = this._context.getProperty("router.updateProxyHost");
        if (host != null) {
            return host;
        }
        return "localhost";
    }

    public String getProxyPort() {
        String port = this._context.getProperty("router.updateProxyPort");
        if (port != null) {
            return port;
        }
        return "4444";
    }

    public String getUpdateThroughProxy() {
        String proxy = this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY);
        if (Boolean.valueOf(proxy).booleanValue()) {
            return "<input type=\"checkbox\" value=\"true\" name=\"updateThroughProxy\" checked=\"true\" >";
        }
        return "<input type=\"checkbox\" value=\"true\" name=\"updateThroughProxy\" >";
    }

    public String getRefreshFrequencySelectBox() {
        String freq = this._context.getProperty("router.newsRefreshFrequency");
        if (freq == null) {
            freq = "43200000";
        }
        long ms = -1L;
        try {
            ms = Long.parseLong(freq);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append("<select name=\"refreshFrequency\">");
        for (int i = 0; i < PERIODS.length; ++i) {
            buf.append("<option value=\"").append(PERIODS[i]);
            if (PERIODS[i] == ms) {
                buf.append("\" selected=\"true\"");
            }
            if (PERIODS[i] == -1L) {
                buf.append("\">Never</option>\n");
                continue;
            }
            buf.append("\">Every ").append(DataHelper.formatDuration(PERIODS[i])).append("</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getUpdatePolicySelectBox() {
        String policy = this._context.getProperty("router.updatePolicy");
        if (policy == null) {
            policy = "notify";
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append("<select name=\"updatePolicy\">");
        if ("notify".equals(policy)) {
            buf.append("<option value=\"notify\" selected=\"true\">Notify only</option>");
        } else {
            buf.append("<option value=\"notify\">Notify only</option>");
        }
        if ("download".equals(policy)) {
            buf.append("<option value=\"download\" selected=\"true\">Download and verify only</option>");
        } else {
            buf.append("<option value=\"download\">Download and verify only</option>");
        }
        if ("install".equals(policy)) {
            buf.append("<option value=\"install\" selected=\"true\">Download, verify, and restart</option>");
        } else {
            buf.append("<option value=\"install\">Download, verify, and restart</option>");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getTrustedKeys() {
        return new TrustedUpdate(this._context).getTrustedKeysString();
    }

    public String getNewsStatus() {
        return NewsFetcher.getInstance(this._context).status();
    }

    public String getUpdateVersion() {
        return NewsFetcher.getInstance(this._context).updateVersion();
    }
}

