/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ContextHelper;
import net.i2p.util.Log;

public class FormHandler {
    protected RouterContext _context;
    protected Log _log;
    private String _nonce = null;
    protected String _action = null;
    protected String _passphrase = null;
    private List _errors = new ArrayList();
    private List _notices = new ArrayList();
    private boolean _processed = false;
    private boolean _valid = true;

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
            this._log = this._context.logManager().getLog(this.getClass());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setNonce(String val) {
        this._nonce = val;
    }

    public void setAction(String val) {
        this._action = val;
    }

    public void setPassphrase(String val) {
        this._passphrase = val;
    }

    protected void processForm() {
    }

    protected void addFormError(String errorMsg) {
        if (errorMsg == null) {
            return;
        }
        this._errors.add(errorMsg);
    }

    protected void addFormNotice(String msg) {
        if (msg == null) {
            return;
        }
        this._notices.add(msg);
    }

    public String getErrors() {
        this.validate();
        return this.render(this._errors);
    }

    public String getNotices() {
        this.validate();
        return this.render(this._notices);
    }

    private void validate() {
        String expected;
        if (this._processed) {
            return;
        }
        this._valid = true;
        if (this._action == null) {
            this._valid = false;
            return;
        }
        if (this._nonce == null) {
            this._valid = false;
            return;
        }
        String sharedNonce = System.getProperty("router.consoleNonce");
        if (sharedNonce != null && sharedNonce.equals(this._nonce)) {
            return;
        }
        String nonce = System.getProperty(this.getClass().getName() + ".nonce");
        String noncePrev = System.getProperty(this.getClass().getName() + ".noncePrev");
        if (!(nonce != null && this._nonce.equals(nonce) || noncePrev != null && this._nonce.equals(noncePrev) || (expected = this._context.getProperty("consolePassword")) != null && expected.trim().length() > 0 && expected.equals(this._passphrase))) {
            this.addFormError("Invalid nonce, are you being spoofed?");
            this._valid = false;
        }
    }

    private String render(List source) {
        if (!this._processed) {
            if (this._valid) {
                this.processForm();
            }
            this._processed = true;
        }
        if (source.size() <= 0) {
            return "";
        }
        if (source.size() == 1) {
            return (String)source.get(0);
        }
        StringBuffer buf = new StringBuffer(512);
        buf.append("<ul>\n");
        for (int i = 0; i < source.size(); ++i) {
            buf.append("<li>");
            buf.append((String)source.get(i));
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        return buf.toString();
    }
}

