/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.AlphaComparator;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryListener;
import net.i2p.stat.Rate;

public class GraphHelper {
    private RouterContext _context;
    private Writer _out;
    private int _periodCount = 60;
    private boolean _showEvents = false;
    private int _width = 250;
    private int _height = 100;
    private int _refreshDelaySeconds = 60;

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setOut(Writer out) {
        this._out = out;
    }

    public void setPeriodCount(String str) {
        try {
            this._periodCount = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setShowEvents(boolean b) {
        this._showEvents = b;
    }

    public void setHeight(String str) {
        try {
            this._height = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setWidth(String str) {
        try {
            this._width = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setRefreshDelay(String str) {
        try {
            this._refreshDelaySeconds = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getImages() {
        try {
            List listeners = StatSummarizer.instance().getListeners();
            TreeSet ordered = new TreeSet(new AlphaComparator());
            ordered.addAll(listeners);
            boolean hasTx = false;
            boolean hasRx = false;
            for (SummaryListener lsnr : ordered) {
                String title = lsnr.getRate().getRateStat().getName();
                if (title.equals("bw.sendRate")) {
                    hasTx = true;
                    continue;
                }
                if (!title.equals("bw.recvRate")) continue;
                hasRx = true;
            }
            if (hasTx && hasRx && !this._showEvents) {
                this._out.write("<a href=\"viewstat.jsp?stat=bw.combined&amp;periodCount=" + 3 * this._periodCount + "&amp;width=" + 3 * this._width + "&amp;height=" + 3 * this._height + "\" />");
                this._out.write("<img width=\"" + (this._width + 83) + "\" height=\"" + (this._height + 92) + "\" src=\"viewstat.jsp?stat=bw.combined" + "&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + (this._height - 14) + "\" title=\"Combined bandwidth graph\" /></a>\n");
            }
            for (SummaryListener lsnr : ordered) {
                Rate r = lsnr.getRate();
                String title = r.getRateStat().getName() + " for " + DataHelper.formatDuration((long)this._periodCount * r.getPeriod());
                this._out.write("<a href=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + 3 * this._periodCount + "&amp;width=" + 3 * this._width + "&amp;height=" + 3 * this._height + "\" />");
                this._out.write("<img border=\"0\" width=\"" + (this._width + 83) + "\" height=\"" + (this._height + 92) + "\" src=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + this._height + "\" title=\"" + title + "\" /></a>\n");
            }
            if (this._refreshDelaySeconds > 0) {
                this._out.write("<meta http-equiv=\"refresh\" content=\"" + this._refreshDelaySeconds + "\" />\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    public String getForm() {
        try {
            this._out.write("<p /><a href=\"configstats.jsp\">Select Stats to Graph</a><p />");
            this._out.write("<form action=\"graphs.jsp\" method=\"GET\">");
            this._out.write("Periods: <input size=\"3\" type=\"text\" name=\"periodCount\" value=\"" + this._periodCount + "\" /><br />\n");
            this._out.write("Plot averages: <input type=\"radio\" name=\"showEvents\" value=\"false\" " + (this._showEvents ? "" : "checked=\"true\" ") + " /> ");
            this._out.write("or plot events: <input type=\"radio\" name=\"showEvents\" value=\"true\" " + (this._showEvents ? "checked=\"true\" " : "") + " /><br />\n");
            this._out.write("Image sizes: width: <input size=\"4\" type=\"text\" name=\"width\" value=\"" + this._width + "\" /> pixels, height: <input size=\"4\" type=\"text\" name=\"height\" value=\"" + this._height + "\" /><br />\n");
            this._out.write("Refresh delay: <select name=\"refreshDelay\"><option value=\"60\">1 minute</option><option value=\"120\">2 minutes</option><option value=\"300\">5 minutes</option><option value=\"600\">10 minutes</option><option value=\"-1\">Never</option></select><br />\n");
            this._out.write("<input type=\"submit\" value=\"Redraw\" />");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    public String getPeerSummary() {
        try {
            this._context.commSystem().renderStatusHTML(this._out);
            this._context.bandwidthLimiter().renderStatusHTML(this._out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }
}

