/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ContextHelper;
import net.i2p.util.EepGet;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class ReseedHandler {
    private static ReseedRunner _reseedRunner;
    private RouterContext _context;
    private Log _log;
    private static final long MAX_RESEED_RESPONSE_SIZE = 0x800000L;
    private static final String DEFAULT_SEED_URL = "http://i2pdb.tin0.de/netDb/,http://netdb.i2p2.de/";

    public ReseedHandler() {
        this(ContextHelper.getContext(null));
    }

    public ReseedHandler(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ReseedHandler.class);
    }

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
            this._log = this._context.logManager().getLog(ReseedHandler.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setReseedNonce(String nonce) {
        if (nonce == null) {
            return;
        }
        if (nonce.equals(System.getProperty("net.i2p.router.web.ReseedHandler.nonce")) || nonce.equals(System.getProperty("net.i2p.router.web.ReseedHandler.noncePrev"))) {
            this.requestReseed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReseed() {
        Class<ReseedHandler> clazz = ReseedHandler.class;
        synchronized (ReseedHandler.class) {
            if (_reseedRunner == null) {
                _reseedRunner = new ReseedRunner();
            }
            if (_reseedRunner.isRunning()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            System.setProperty("net.i2p.router.web.ReseedHandler.reseedInProgress", "true");
            I2PThread reseed = new I2PThread(_reseedRunner, "Reseed");
            reseed.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) {
        if (args != null && args.length == 1 && !Boolean.valueOf(args[0]).booleanValue()) {
            System.out.println("Not reseeding, as requested");
            return;
        }
        System.out.println("Reseeding");
        ReseedHandler reseedHandler = new ReseedHandler();
        reseedHandler.requestReseed();
    }

    public class ReseedRunner
    implements Runnable,
    EepGet.StatusListener {
        private boolean _isRunning = false;
        private static final String RESEED_TIPS = "Ensure that nothing blocks outbound HTTP, check <a href=logs.jsp>logs</a> and if nothing helps, read FAQ about reseeding manually.";

        public ReseedRunner() {
            System.setProperty("net.i2p.router.web.ReseedHandler.statusMessage", "Reseeding.");
        }

        public boolean isRunning() {
            return this._isRunning;
        }

        public void run() {
            this._isRunning = true;
            this.reseed(false);
            System.out.println("Reseeding complete");
            System.setProperty("net.i2p.router.web.ReseedHandler.reseedInProgress", "false");
            this._isRunning = false;
        }

        public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
            if (ReseedHandler.this._log.shouldLog(40)) {
                ReseedHandler.this._log.error("EepGet failed on " + url, cause);
            }
        }

        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        }

        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        }

        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        }

        public void headerReceived(String url, int attemptNum, String key, String val) {
        }

        public void attempting(String url) {
        }

        private void reseed(boolean echoStatus) {
            ArrayList<String> URLList = new ArrayList<String>();
            String URLs = ReseedHandler.this._context.getProperty("i2p.reseedURL", ReseedHandler.DEFAULT_SEED_URL);
            StringTokenizer tok = new StringTokenizer(URLs, " ,");
            while (tok.hasMoreTokens()) {
                URLList.add(tok.nextToken().trim());
            }
            Collections.shuffle(URLList);
            for (int i = 0; i < URLList.size() && this._isRunning; ++i) {
                this.reseedOne((String)URLList.get(i), echoStatus);
            }
        }

        private void reseedOne(String seedURL, boolean echoStatus) {
            try {
                int failPercent;
                int start;
                System.setProperty("net.i2p.router.web.ReseedHandler.errorMessage", "");
                System.setProperty("net.i2p.router.web.ReseedHandler.statusMessage", "Reseeding: fetching seed URL.");
                URL dir = new URL(seedURL);
                byte[] contentRaw = this.readURL(dir);
                if (contentRaw == null) {
                    System.setProperty("net.i2p.router.web.ReseedHandler.errorMessage", "Last reseed failed fully (failed reading seed URL). Ensure that nothing blocks outbound HTTP, check <a href=logs.jsp>logs</a> and if nothing helps, read FAQ about reseeding manually.");
                    ReseedHandler.this._log.debug("Failed reading seed URL: " + seedURL);
                    return;
                }
                String content = new String(contentRaw);
                HashSet<String> urls = new HashSet<String>();
                int cur = 0;
                while ((start = content.indexOf("href=\"routerInfo-", cur)) >= 0) {
                    int end = content.indexOf(".dat\">", start);
                    String name = content.substring(start + "href=\"routerInfo-".length(), end);
                    urls.add(name);
                    cur = end + 1;
                }
                if (urls.size() <= 0) {
                    ReseedHandler.this._log.error("Read " + contentRaw.length + " bytes from seed " + seedURL + ", but found no routerInfo URLs.");
                    System.setProperty("net.i2p.router.web.ReseedHandler.errorMessage", "Last reseed failed fully (no routerInfo URLs at seed URL). Ensure that nothing blocks outbound HTTP, check <a href=logs.jsp>logs</a> and if nothing helps, read FAQ about reseeding manually.");
                    return;
                }
                int fetched = 0;
                int errors = 0;
                Iterator iter = urls.iterator();
                while (iter.hasNext()) {
                    try {
                        System.setProperty("net.i2p.router.web.ReseedHandler.statusMessage", "Reseeding: fetching router info from seed URL (" + fetched + " successful, " + errors + " errors, " + urls.size() + " total).");
                        this.fetchSeed(seedURL, (String)iter.next());
                        ++fetched;
                        if (!echoStatus) continue;
                        System.out.print(".");
                        if (fetched % 60 != 0) continue;
                        System.out.println();
                    }
                    catch (Exception e) {
                        ++errors;
                    }
                }
                if (echoStatus) {
                    System.out.println();
                }
                if ((failPercent = 100 * errors / urls.size()) >= 10 && failPercent < 90) {
                    System.setProperty("net.i2p.router.web.ReseedHandler.errorMessage", "Last reseed failed partly (" + failPercent + "% of " + urls.size() + "). " + RESEED_TIPS);
                }
                if (failPercent >= 90) {
                    System.setProperty("net.i2p.router.web.ReseedHandler.errorMessage", "Last reseed failed (" + failPercent + "% of " + urls.size() + "). " + RESEED_TIPS);
                }
                if (fetched > 25) {
                    this._isRunning = false;
                }
            }
            catch (Throwable t) {
                System.setProperty("net.i2p.router.web.ReseedHandler.errorMessage", "Last reseed failed fully (exception caught). Ensure that nothing blocks outbound HTTP, check <a href=logs.jsp>logs</a> and if nothing helps, read FAQ about reseeding manually.");
                ReseedHandler.this._log.error("Error reseeding", t);
            }
        }

        private void fetchSeed(String seedURL, String peer) throws Exception {
            URL url = new URL(seedURL + (seedURL.endsWith("/") ? "" : "/") + "routerInfo-" + peer + ".dat");
            byte[] data = this.readURL(url);
            if (data == null) {
                ReseedHandler.this._log.debug("Failed fetching seed: " + url.toString());
                throw new Exception("Failed fetching seed.");
            }
            this.writeSeed(peer, data);
        }

        private byte[] readURL(URL url) throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            EepGet get = new EepGet(I2PAppContext.getGlobalContext(), false, null, -1, 0, 0L, 0x800000L, null, baos, url.toString(), false, null, null);
            get.addStatusListener(this);
            if (get.fetch()) {
                return baos.toByteArray();
            }
            return null;
        }

        private void writeSeed(String name, byte[] data) throws Exception {
            String dirName = "netDb";
            File netDbDir = new File(dirName);
            if (!netDbDir.exists()) {
                boolean ok = netDbDir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(new File(netDbDir, "routerInfo-" + name + ".dat"));
            fos.write(data);
            fos.close();
        }
    }
}

