/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterAddress;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.NewsFetcher;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

public class SummaryHelper {
    private RouterContext _context;
    private static final DateFormat _fmt = new SimpleDateFormat("HH:mm:ss", Locale.UK);

    public void setContextId(String contextId) {
        try {
            this._context = ContextHelper.getContext(contextId);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getIdent() {
        if (this._context == null) {
            return "[no router]";
        }
        if (this._context.routerHash() != null) {
            return this._context.routerHash().toBase64().substring(0, 4);
        }
        return "[unknown]";
    }

    public String getVersion() {
        return "0.6.5-0";
    }

    public String getUptime() {
        if (this._context == null) {
            return "[no router]";
        }
        Router router = this._context.router();
        if (router == null) {
            return "[not up]";
        }
        return DataHelper.formatDuration(router.getUptime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTime() {
        if (this._context == null) {
            return "";
        }
        String now = null;
        DateFormat dateFormat = _fmt;
        synchronized (dateFormat) {
            now = _fmt.format(new Date(this._context.clock().now()));
        }
        if (!this._context.clock().getUpdatedSuccessfully()) {
            return now + " (Unknown skew)";
        }
        long ms = this._context.clock().getOffset();
        long diff = ms;
        if (diff < 0L) {
            diff = 0L - diff;
        }
        if (diff == 0L) {
            return now + " (no skew)";
        }
        if (diff < 1000L) {
            return now + " (" + ms + "ms skew)";
        }
        if (diff < 5000L) {
            return now + " (" + ms / 1000L + "s skew)";
        }
        if (diff < 60000L) {
            return now + " <b>(" + ms / 1000L + "s skew)</b>";
        }
        if (diff < 3600000L) {
            return now + " <b>(" + ms / 60000L + "m skew)</b>";
        }
        if (diff < 86400000L) {
            return now + " <b>(" + ms / 3600000L + "h skew)</b>";
        }
        return now + " <b>(" + ms / 86400000L + "d skew)</b>";
    }

    public boolean allowReseed() {
        return this._context.netDb().getKnownRouters() < 30 || Boolean.valueOf(this._context.getProperty("i2p.alwaysAllowReseed", "false")) != false;
    }

    public int getAllPeers() {
        return this._context.netDb().getKnownRouters();
    }

    public String getReachability() {
        if (!this._context.clock().getUpdatedSuccessfully()) {
            return "ERR-ClockSkew";
        }
        if (this._context.router().isHidden()) {
            return "Hidden";
        }
        short status = this._context.commSystem().getReachabilityStatus();
        switch (status) {
            case 0: {
                RouterAddress ra = this._context.router().getRouterInfo().getTargetAddress("NTCP");
                if (ra == null || new NTCPAddress(ra).isPubliclyRoutable()) {
                    return "OK";
                }
                return "ERR-Private TCP Address";
            }
            case 1: {
                return "ERR-SymmetricNAT";
            }
            case 2: {
                if (this._context.router().getRouterInfo().getTargetAddress("NTCP") != null) {
                    return "WARN-Firewalled with Inbound TCP Enabled";
                }
                if (((FloodfillNetworkDatabaseFacade)this._context.netDb()).floodfillEnabled()) {
                    return "WARN-Firewalled and Floodfill";
                }
                if (this._context.router().getRouterInfo().getCapabilities().indexOf(79) >= 0) {
                    return "WARN-Firewalled and Fast";
                }
                return "Firewalled";
            }
            case 3: {
                return "ERR-UDP Port In Use - Set i2np.udp.internalPort=xxxx in advanced config and restart";
            }
        }
        return "Testing";
    }

    public String getMemory() {
        DecimalFormat integerFormatter = new DecimalFormat("###,###,##0");
        long used = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        long usedPc = 100L - Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory();
        return integerFormatter.format(used) + "KB (" + usedPc + "%)";
    }

    public int getActivePeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.commSystem().countActivePeers();
    }

    public int getActiveProfiles() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countActivePeers();
    }

    public int getFastPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countFastPeers();
    }

    public int getHighCapacityPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countHighCapacityPeers();
    }

    public int getWellIntegratedPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countWellIntegratedPeers();
    }

    public int getFailingPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countFailingPeers();
    }

    public int getShitlistedPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.shitlist().getRouterCount();
    }

    public String getInboundSecondKBps() {
        if (this._context == null) {
            return "0.0";
        }
        double kbps = (double)this._context.bandwidthLimiter().getReceiveBps() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getOutboundSecondKBps() {
        if (this._context == null) {
            return "0.0";
        }
        double kbps = (double)this._context.bandwidthLimiter().getSendBps() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getInboundFiveMinuteKBps() {
        if (this._context == null) {
            return "0.0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.recvRate");
        if (receiveRate == null) {
            return "0.0";
        }
        Rate rate = receiveRate.getRate(300000L);
        double kbps = rate.getAverageValue() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getOutboundFiveMinuteKBps() {
        if (this._context == null) {
            return "0.0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.sendRate");
        if (receiveRate == null) {
            return "0.0";
        }
        Rate rate = receiveRate.getRate(300000L);
        double kbps = rate.getAverageValue() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getInboundLifetimeKBps() {
        if (this._context == null) {
            return "0.0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.recvRate");
        if (receiveRate == null) {
            return "0.0";
        }
        double kbps = receiveRate.getLifetimeAverageValue() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getOutboundLifetimeKBps() {
        if (this._context == null) {
            return "0.0";
        }
        RateStat sendRate = this._context.statManager().getRate("bw.sendRate");
        if (sendRate == null) {
            return "0.0";
        }
        double kbps = sendRate.getLifetimeAverageValue() / 1024.0;
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(kbps);
    }

    public String getInboundTransferred() {
        if (this._context == null) {
            return "0.0";
        }
        long received = this._context.bandwidthLimiter().getTotalAllocatedInboundBytes();
        return SummaryHelper.getTransferred(received);
    }

    public String getOutboundTransferred() {
        if (this._context == null) {
            return "0.0";
        }
        long sent = this._context.bandwidthLimiter().getTotalAllocatedOutboundBytes();
        return SummaryHelper.getTransferred(sent);
    }

    private static String getTransferred(long bytes) {
        double val = bytes;
        int scale = 0;
        if (bytes > 0x40000000L) {
            scale = 3;
            val /= 1.073741824E9;
        } else if (bytes > 0x100000L) {
            scale = 2;
            val /= 1048576.0;
        } else if (bytes > 1024L) {
            scale = 1;
            val /= 1024.0;
        } else {
            scale = 0;
        }
        DecimalFormat fmt = new DecimalFormat("##0.00");
        String str = fmt.format(val);
        switch (scale) {
            case 1: {
                return str + "KB";
            }
            case 2: {
                return str + "MB";
            }
            case 3: {
                return str + "GB";
            }
        }
        return bytes + "bytes";
    }

    public String getDestinations() {
        Set clients = this._context.clientManager().listClients();
        StringBuffer buf = new StringBuffer(512);
        buf.append("<u><b>Local destinations</b></u><br />");
        for (Destination client : clients) {
            String name;
            TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(client.calculateHash());
            TunnelPoolSettings out = this._context.tunnelManager().getOutboundSettings(client.calculateHash());
            String string = name = in != null ? in.getDestinationNickname() : null;
            if (name == null) {
                String string2 = name = out != null ? out.getDestinationNickname() : null;
            }
            if (name == null) {
                name = client.calculateHash().toBase64().substring(0, 6);
            }
            buf.append("<b>*</b> ").append(name).append("<br />\n");
            LeaseSet ls = this._context.netDb().lookupLeaseSetLocally(client.calculateHash());
            if (ls != null) {
                long timeToExpire = ls.getEarliestLeaseDate() - this._context.clock().now();
                if (timeToExpire < 0L) {
                    buf.append("<i>expired ").append(DataHelper.formatDuration(0L - timeToExpire));
                    buf.append(" ago</i><br />\n");
                }
            } else {
                buf.append("<i>No leases</i><br />\n");
            }
            buf.append("<a href=\"tunnels.jsp#").append(client.calculateHash().toBase64().substring(0, 4));
            buf.append("\">Details</a> ");
            buf.append("<a href=\"configtunnels.jsp#").append(client.calculateHash().toBase64().substring(0, 4));
            buf.append("\">Config</a><br />\n");
        }
        buf.append("<hr />\n");
        return buf.toString();
    }

    public int getInboundTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getFreeTunnelCount();
    }

    public int getOutboundTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getOutboundTunnelCount();
    }

    public int getInboundClientTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getInboundClientTunnelCount();
    }

    public int getOutboundClientTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getOutboundClientTunnelCount();
    }

    public int getParticipatingTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getParticipatingCount();
    }

    public String getJobLag() {
        if (this._context == null) {
            return "0ms";
        }
        Rate lagRate = this._context.statManager().getRate("jobQueue.jobLag").getRate(60000L);
        return (int)lagRate.getAverageValue() + "ms";
    }

    public String getMessageDelay() {
        if (this._context == null) {
            return "0ms";
        }
        return this._context.throttle().getMessageDelay() + "ms";
    }

    public String getTunnelLag() {
        if (this._context == null) {
            return "0ms";
        }
        return this._context.throttle().getTunnelLag() + "ms";
    }

    public String getTunnelStatus() {
        if (this._context == null) {
            return "";
        }
        return this._context.throttle().getTunnelStatus();
    }

    public String getInboundBacklog() {
        if (this._context == null) {
            return "0";
        }
        return String.valueOf(this._context.tunnelManager().getInboundBuildQueueSize());
    }

    public String getPRNGStatus() {
        Rate r = this._context.statManager().getRate("prng.bufferWaitTime").getRate(60000L);
        int use = (int)r.getLastEventCount();
        int i = (int)(r.getAverageValue() + 0.5);
        if (i <= 0) {
            r = this._context.statManager().getRate("prng.bufferWaitTime").getRate(600000L);
            i = (int)(r.getAverageValue() + 0.5);
        }
        String rv = i + "/";
        r = this._context.statManager().getRate("prng.bufferFillTime").getRate(60000L);
        i = (int)(r.getAverageValue() + 0.5);
        if (i <= 0) {
            r = this._context.statManager().getRate("prng.bufferFillTime").getRate(600000L);
            i = (int)(r.getAverageValue() + 0.5);
        }
        rv = rv + i + "ms";
        if (use > 0 && i > 0) {
            rv = rv + ' ' + 60000 / (use * i) + 'x';
        }
        return rv;
    }

    public boolean updateAvailable() {
        return NewsFetcher.getInstance(this._context).updateAvailable();
    }
}

