/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import net.i2p.I2PAppContext;
import net.i2p.client.HandlerImpl;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.SessionStatusMessage;

class SessionStatusMessageHandler
extends HandlerImpl {
    public SessionStatusMessageHandler(I2PAppContext context) {
        super(context, 20);
    }

    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        this._log.debug("Handle message " + message);
        SessionStatusMessage msg = (SessionStatusMessage)message;
        session.setSessionId(msg.getSessionId());
        switch (msg.getStatus()) {
            case 1: {
                this._log.info("Session created successfully");
                break;
            }
            case 0: {
                this._log.info("Session destroyed");
                session.reconnect();
                break;
            }
            case 3: {
                session.destroySession();
                break;
            }
            case 2: {
                this._log.info("Session status updated");
                break;
            }
            default: {
                this._log.warn("Unknown session status sent: " + msg.getStatus());
            }
        }
    }
}

