/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.lang.reflect.Constructor;
import java.util.Collection;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyAddressDB;
import net.i2p.client.naming.NamingService;
import net.i2p.data.Address;
import net.i2p.util.Log;

public abstract class AddressDB {
    private static final Log _log = new Log(NamingService.class);
    protected I2PAppContext _context;
    public static final String PROP_IMPL = "i2p.addressdb.impl";
    private static final String DEFAULT_IMPL = "net.i2p.client.naming.FilesystemAddressDB";

    protected AddressDB(I2PAppContext context) {
        this._context = context;
    }

    private AddressDB() {
    }

    public static final synchronized AddressDB createInstance(I2PAppContext context) {
        AddressDB instance = null;
        String impl = context.getProperty(PROP_IMPL, DEFAULT_IMPL);
        try {
            Class<?> cls = Class.forName(impl);
            Constructor<?> con = cls.getConstructor(I2PAppContext.class);
            instance = (AddressDB)con.newInstance(context);
        }
        catch (Exception ex) {
            _log.error("Cannot load address db implementation", ex);
            instance = new DummyAddressDB(context);
        }
        return instance;
    }

    public abstract Address get(String var1);

    public abstract Address put(Address var1);

    public abstract Address remove(String var1);

    public abstract Address remove(Address var1);

    public abstract boolean contains(Address var1);

    public abstract boolean contains(String var1);

    public abstract Collection hostnames();
}

