/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;

public class DHSessionKeyBuilder {
    private static I2PAppContext _context;
    private static final Log _log;
    private static int MIN_NUM_BUILDERS;
    private static int MAX_NUM_BUILDERS;
    private static int CALC_DELAY;
    private static volatile List _builders;
    private static Thread _precalcThread;
    private BigInteger _myPrivateValue = null;
    private BigInteger _myPublicValue = null;
    private BigInteger _peerValue = null;
    private SessionKey _sessionKey = null;
    private ByteArray _extraExchangedBytes = new ByteArray();
    public static final String PROP_DH_PRECALC_MIN = "crypto.dh.precalc.min";
    public static final String PROP_DH_PRECALC_MAX = "crypto.dh.precalc.max";
    public static final String PROP_DH_PRECALC_DELAY = "crypto.dh.precalc.delay";
    public static final String DEFAULT_DH_PRECALC_MIN = "5";
    public static final String DEFAULT_DH_PRECALC_MAX = "50";
    public static final String DEFAULT_DH_PRECALC_DELAY = "10000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHSessionKeyBuilder() {
        this(false);
        DHSessionKeyBuilder builder = null;
        List list = _builders;
        synchronized (list) {
            if (_builders.size() > 0) {
                builder = (DHSessionKeyBuilder)_builders.remove(0);
                if (_log.shouldLog(10)) {
                    _log.debug("Removing a builder.  # left = " + _builders.size());
                }
            } else if (_log.shouldLog(30)) {
                _log.warn("NO MORE BUILDERS!  creating one now");
            }
        }
        if (builder != null) {
            this._myPrivateValue = builder._myPrivateValue;
            this._myPublicValue = builder._myPublicValue;
            this._peerValue = builder._peerValue;
            this._sessionKey = builder._sessionKey;
            this._extraExchangedBytes = builder._extraExchangedBytes;
        } else {
            this._myPrivateValue = null;
            this._myPublicValue = null;
            this._peerValue = null;
            this._sessionKey = null;
            this._myPublicValue = this.generateMyValue();
            this._extraExchangedBytes = new ByteArray();
        }
    }

    public DHSessionKeyBuilder(boolean usePool) {
    }

    public static DHSessionKeyBuilder exchangeKeys(InputStream in, OutputStream out) throws IOException {
        DHSessionKeyBuilder builder = new DHSessionKeyBuilder();
        DHSessionKeyBuilder.writeBigI(out, builder.getMyPublicValue());
        BigInteger Y = DHSessionKeyBuilder.readBigI(in);
        if (Y == null) {
            return null;
        }
        try {
            builder.setPeerPublicValue(Y);
            return builder;
        }
        catch (InvalidPublicParameterException ippe) {
            if (_log.shouldLog(40)) {
                _log.error("Key exchange failed (hostile peer?)", ippe);
            }
            return null;
        }
    }

    static BigInteger readBigI(InputStream in) throws IOException {
        byte[] Y = new byte[256];
        int read = DataHelper.read(in, Y);
        if (read != 256) {
            return null;
        }
        if (1 == (Y[0] & 0x80)) {
            if (_log.shouldLog(10)) {
                _log.debug("High bit set");
            }
            byte[] Y2 = new byte[257];
            System.arraycopy(Y, 0, Y2, 1, 256);
            Y = Y2;
        }
        return new NativeBigInteger(1, Y);
    }

    static void writeBigI(OutputStream out, BigInteger val) throws IOException {
        byte[] x = val.toByteArray();
        for (int i = x.length; i < 256; ++i) {
            out.write(0);
        }
        if (x.length == 257) {
            out.write(x, 1, 256);
        } else if (x.length == 256) {
            out.write(x);
        } else if (x.length > 257) {
            throw new IllegalArgumentException("Value is too large!  length=" + x.length);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getSize() {
        List list = _builders;
        synchronized (list) {
            return _builders.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int addBuilder(DHSessionKeyBuilder builder) {
        int sz = 0;
        List list = _builders;
        synchronized (list) {
            _builders.add(builder);
            sz = _builders.size();
        }
        return sz;
    }

    public BigInteger generateMyValue() {
        long start = System.currentTimeMillis();
        this._myPrivateValue = new NativeBigInteger(226, RandomSource.getInstance());
        BigInteger myValue = CryptoConstants.elgg.modPow(this._myPrivateValue, CryptoConstants.elgp);
        long end = System.currentTimeMillis();
        long diff = end - start;
        _context.statManager().addRateData("crypto.dhGeneratePublicTime", diff, diff);
        if (diff > 1000L) {
            if (_log.shouldLog(30)) {
                _log.warn("Took more than a second (" + diff + "ms) to generate local DH value");
            }
        } else if (_log.shouldLog(10)) {
            _log.debug("Took " + diff + "ms to generate local DH value");
        }
        return myValue;
    }

    public BigInteger getMyPrivateValue() {
        return this._myPrivateValue;
    }

    public BigInteger getMyPublicValue() {
        if (this._myPublicValue == null) {
            this._myPublicValue = this.generateMyValue();
        }
        return this._myPublicValue;
    }

    public byte[] getMyPublicValueBytes() {
        return DHSessionKeyBuilder.toByteArray(this.getMyPublicValue());
    }

    private static final byte[] toByteArray(BigInteger bi) {
        byte[] data = bi.toByteArray();
        byte[] rv = new byte[256];
        if (data.length == 257) {
            System.arraycopy(data, 1, rv, 0, rv.length);
        } else if (data.length == 256) {
            System.arraycopy(data, 0, rv, 0, rv.length);
        } else {
            System.arraycopy(data, 0, rv, rv.length - data.length, data.length);
        }
        return rv;
    }

    public void setPeerPublicValue(BigInteger peerVal) throws InvalidPublicParameterException {
        DHSessionKeyBuilder.validatePublic(peerVal);
        this._peerValue = peerVal;
    }

    public void setPeerPublicValue(byte[] val) throws InvalidPublicParameterException {
        if (val.length != 256) {
            throw new IllegalArgumentException("Peer public value must be exactly 256 bytes");
        }
        if (1 == (val[0] & 0x80)) {
            if (_log.shouldLog(10)) {
                _log.debug("High bit set");
            }
            byte[] val2 = new byte[257];
            System.arraycopy(val, 0, val2, 1, 256);
            val = val2;
        }
        this.setPeerPublicValue(new NativeBigInteger(1, val));
    }

    public BigInteger getPeerPublicValue() {
        return this._peerValue;
    }

    public byte[] getPeerPublicValueBytes() {
        return DHSessionKeyBuilder.toByteArray(this.getPeerPublicValue());
    }

    public SessionKey getSessionKey() {
        if (this._sessionKey != null) {
            return this._sessionKey;
        }
        if (this._peerValue != null) {
            if (this._myPrivateValue == null) {
                this.generateMyValue();
            }
            this._sessionKey = this.calculateSessionKey(this._myPrivateValue, this._peerValue);
        }
        return this._sessionKey;
    }

    public ByteArray getExtraBytes() {
        return this._extraExchangedBytes;
    }

    private final SessionKey calculateSessionKey(BigInteger myPrivateValue, BigInteger publicPeerValue) {
        byte[] remaining;
        byte[] val;
        long start = System.currentTimeMillis();
        SessionKey key = new SessionKey();
        BigInteger exchangedKey = publicPeerValue.modPow(myPrivateValue, CryptoConstants.elgp);
        byte[] buf = exchangedKey.toByteArray();
        if (buf.length < (val = new byte[32]).length) {
            System.arraycopy(buf, 0, val, 0, buf.length);
            remaining = SHA256Generator.getInstance().calculateHash(val).getData();
            this._extraExchangedBytes.setData(remaining);
            if (_log.shouldLog(10)) {
                _log.debug("Storing " + remaining.length + " bytes from the DH exchange by SHA256 the session key");
            }
        } else {
            System.arraycopy(buf, 0, val, 0, val.length);
            _context.random().harvester().feedEntropy("DH", buf, val.length, buf.length - val.length);
            remaining = new byte[buf.length - val.length];
            System.arraycopy(buf, val.length, remaining, 0, remaining.length);
            this._extraExchangedBytes.setData(remaining);
            if (_log.shouldLog(10)) {
                _log.debug("Storing " + remaining.length + " bytes from the end of the DH exchange");
            }
        }
        key.setData(val);
        long end = System.currentTimeMillis();
        long diff = end - start;
        _context.statManager().addRateData("crypto.dhCalculateSessionTime", diff, diff);
        if (diff > 1000L) {
            if (_log.shouldLog(30)) {
                _log.warn("Generating session key took too long (" + diff + " ms");
            }
        } else if (_log.shouldLog(10)) {
            _log.debug("Generating session key " + diff + " ms");
        }
        return key;
    }

    private static final void validatePublic(BigInteger publicValue) throws InvalidPublicParameterException {
        int cmp = publicValue.compareTo(NativeBigInteger.ONE);
        if (cmp <= 0) {
            throw new InvalidPublicParameterException("Public value is below two: " + publicValue.toString());
        }
        cmp = publicValue.compareTo(CryptoConstants.elgp);
        if (cmp >= 0) {
            throw new InvalidPublicParameterException("Public value is above p-1: " + publicValue.toString());
        }
    }

    public static void main(String[] args) {
        RandomSource.getInstance().nextBoolean();
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        I2PAppContext ctx = new I2PAppContext();
        _log.debug("\n\n\n\nBegin test\n");
        long negTime = 0L;
        try {
            for (int i = 0; i < 5; ++i) {
                long startNeg = Clock.getInstance().now();
                DHSessionKeyBuilder builder1 = new DHSessionKeyBuilder();
                DHSessionKeyBuilder builder2 = new DHSessionKeyBuilder();
                BigInteger pub1 = builder1.getMyPublicValue();
                builder2.setPeerPublicValue(pub1);
                BigInteger pub2 = builder2.getMyPublicValue();
                builder1.setPeerPublicValue(pub2);
                SessionKey key1 = builder1.getSessionKey();
                SessionKey key2 = builder2.getSessionKey();
                long endNeg = Clock.getInstance().now();
                negTime += endNeg - startNeg;
                if (!key1.equals(key2)) {
                    _log.error("**ERROR: Keys do not match");
                } else {
                    _log.debug("**Success: Keys match");
                }
                byte[] iv = new byte[16];
                RandomSource.getInstance().nextBytes(iv);
                String origVal = "1234567890123456";
                byte[] enc = new byte[16];
                byte[] dec = new byte[16];
                ctx.aes().encrypt(origVal.getBytes(), 0, enc, 0, key1, iv, 16);
                ctx.aes().decrypt(enc, 0, dec, 0, key2, iv, 16);
                String tranVal = new String(dec);
                if (origVal.equals(tranVal)) {
                    _log.debug("**Success: D(E(val)) == val");
                    continue;
                }
                _log.error("**ERROR: D(E(val)) != val [val=(" + tranVal + "), origVal=(" + origVal + ")");
            }
        }
        catch (InvalidPublicParameterException ippe) {
            _log.error("Invalid dh", ippe);
        }
        _log.debug("Negotiation time for 5 runs: " + negTime + " @ " + negTime / 5L + "ms each");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    static {
        int val;
        int val2;
        _context = I2PAppContext.getGlobalContext();
        _log = new Log(DHSessionKeyBuilder.class);
        MIN_NUM_BUILDERS = -1;
        MAX_NUM_BUILDERS = -1;
        CALC_DELAY = -1;
        _builders = new ArrayList(50);
        _precalcThread = null;
        I2PAppContext ctx = _context;
        ctx.statManager().createRateStat("crypto.dhGeneratePublicTime", "How long it takes to create x and X", "Encryption", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRateStat("crypto.dhCalculateSessionTime", "How long it takes to create the session key", "Encryption", new long[]{60000L, 300000L, 3600000L});
        try {
            MIN_NUM_BUILDERS = val2 = Integer.parseInt(ctx.getProperty(PROP_DH_PRECALC_MIN, DEFAULT_DH_PRECALC_MIN));
        }
        catch (Throwable t) {
            MIN_NUM_BUILDERS = val = Integer.parseInt(DEFAULT_DH_PRECALC_MIN);
        }
        try {
            MAX_NUM_BUILDERS = val2 = Integer.parseInt(ctx.getProperty(PROP_DH_PRECALC_MAX, DEFAULT_DH_PRECALC_MAX));
        }
        catch (Throwable t) {
            MAX_NUM_BUILDERS = val = Integer.parseInt(DEFAULT_DH_PRECALC_MAX);
        }
        try {
            int val3;
            CALC_DELAY = val3 = Integer.parseInt(ctx.getProperty(PROP_DH_PRECALC_DELAY, DEFAULT_DH_PRECALC_DELAY));
        }
        catch (Throwable t) {
            CALC_DELAY = val = Integer.parseInt(DEFAULT_DH_PRECALC_DELAY);
        }
        if (_log.shouldLog(10)) {
            _log.debug("DH Precalc (minimum: " + MIN_NUM_BUILDERS + " max: " + MAX_NUM_BUILDERS + ", delay: " + CALC_DELAY + ")");
        }
        _precalcThread = new I2PThread(new DHSessionKeyBuilderPrecalcRunner(MIN_NUM_BUILDERS, MAX_NUM_BUILDERS));
        _precalcThread.setName("DH Precalc");
        _precalcThread.setDaemon(true);
        _precalcThread.setPriority(1);
        _precalcThread.start();
    }

    public static class InvalidPublicParameterException
    extends I2PException {
        public InvalidPublicParameterException() {
        }

        public InvalidPublicParameterException(String msg) {
            super(msg);
        }
    }

    private static class DHSessionKeyBuilderPrecalcRunner
    implements Runnable {
        private int _minSize;
        private int _maxSize;

        private DHSessionKeyBuilderPrecalcRunner(int minSize, int maxSize) {
            this._minSize = minSize;
            this._maxSize = maxSize;
        }

        public void run() {
            while (true) {
                int startSize;
                int curSize = 0;
                long start = Clock.getInstance().now();
                curSize = startSize = DHSessionKeyBuilder.getSize();
                while (curSize < this._minSize) {
                    while (curSize < this._maxSize) {
                        long curStart = System.currentTimeMillis();
                        curSize = DHSessionKeyBuilder.addBuilder(this.precalc(curSize));
                        long curCalc = System.currentTimeMillis() - curStart;
                        try {
                            Thread.sleep((long)CALC_DELAY + curCalc * 10L);
                        }
                        catch (InterruptedException ie) {}
                    }
                }
                long end = Clock.getInstance().now();
                int numCalc = curSize - startSize;
                if (numCalc > 0 && _log.shouldLog(10)) {
                    _log.debug("Precalced " + numCalc + " to " + curSize + " in " + (end - start - (long)(CALC_DELAY * numCalc)) + "ms (not counting " + CALC_DELAY * numCalc + "ms relief).  now sleeping");
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ie) {
                }
            }
        }

        private DHSessionKeyBuilder precalc(int i) {
            DHSessionKeyBuilder builder = new DHSessionKeyBuilder(false);
            builder.getMyPublicValue();
            return builder;
        }
    }
}

