/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.DSAEngine;
import net.i2p.data.DataHelper;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;

public class KeyGenerator {
    private Log _log;
    private I2PAppContext _context;
    private static final int PBE_ROUNDS = 1000;
    private static final int PUBKEY_EXPONENT_SIZE_FULL = 2048;
    private static final int PUBKEY_EXPONENT_SIZE_SHORT = 226;
    public static final int PUBKEY_EXPONENT_SIZE = 226;

    public KeyGenerator(I2PAppContext context) {
        this._log = context.logManager().getLog(KeyGenerator.class);
        this._context = context;
    }

    public static KeyGenerator getInstance() {
        return I2PAppContext.getGlobalContext().keyGenerator();
    }

    public SessionKey generateSessionKey() {
        SessionKey key = new SessionKey();
        byte[] data = new byte[32];
        this._context.random().nextBytes(data);
        key.setData(data);
        return key;
    }

    public SessionKey generateSessionKey(byte[] salt, byte[] passphrase) {
        byte[] salted = new byte[16 + passphrase.length];
        System.arraycopy(salt, 0, salted, 0, Math.min(salt.length, 16));
        System.arraycopy(passphrase, 0, salted, 16, passphrase.length);
        byte[] h = this._context.sha().calculateHash(salted).getData();
        for (int i = 1; i < 1000; ++i) {
            this._context.sha().calculateHash(h, 0, 32, h, 0);
        }
        return new SessionKey(h);
    }

    public Object[] generatePKIKeypair() {
        NativeBigInteger a = new NativeBigInteger(226, this._context.random());
        BigInteger aalpha = CryptoConstants.elgg.modPow(a, CryptoConstants.elgp);
        Object[] keys = new Object[]{new PublicKey(), new PrivateKey()};
        byte[] k0 = aalpha.toByteArray();
        byte[] k1 = ((BigInteger)a).toByteArray();
        ((PublicKey)keys[0]).setData(KeyGenerator.padBuffer(k0, 256));
        ((PrivateKey)keys[1]).setData(KeyGenerator.padBuffer(k1, 256));
        return keys;
    }

    public static PublicKey getPublicKey(PrivateKey priv) {
        NativeBigInteger a = new NativeBigInteger(1, priv.toByteArray());
        BigInteger aalpha = CryptoConstants.elgg.modPow(a, CryptoConstants.elgp);
        PublicKey pub = new PublicKey();
        byte[] pubBytes = aalpha.toByteArray();
        pub.setData(KeyGenerator.padBuffer(pubBytes, 256));
        return pub;
    }

    public Object[] generateSigningKeypair() {
        Object[] keys = new Object[2];
        NativeBigInteger x = null;
        while ((x = new NativeBigInteger(160, this._context.random())).compareTo(CryptoConstants.dsaq) >= 0) {
        }
        BigInteger y = CryptoConstants.dsag.modPow(x, CryptoConstants.dsap);
        keys[0] = new SigningPublicKey();
        keys[1] = new SigningPrivateKey();
        byte[] k0 = KeyGenerator.padBuffer(y.toByteArray(), 128);
        byte[] k1 = KeyGenerator.padBuffer(((BigInteger)x).toByteArray(), 20);
        ((SigningPublicKey)keys[0]).setData(k0);
        ((SigningPrivateKey)keys[1]).setData(k1);
        return keys;
    }

    public static SigningPublicKey getSigningPublicKey(SigningPrivateKey priv) {
        NativeBigInteger x = new NativeBigInteger(1, priv.toByteArray());
        BigInteger y = CryptoConstants.dsag.modPow(x, CryptoConstants.dsap);
        SigningPublicKey pub = new SigningPublicKey();
        byte[] pubBytes = KeyGenerator.padBuffer(y.toByteArray(), 128);
        pub.setData(pubBytes);
        return pub;
    }

    static final byte[] padBuffer(byte[] src, int length) {
        byte[] buf = new byte[length];
        if (src.length > buf.length) {
            System.arraycopy(src, src.length - buf.length, buf, 0, buf.length);
        } else if (src.length < buf.length) {
            System.arraycopy(src, 0, buf, buf.length - src.length, src.length);
        } else {
            System.arraycopy(src, 0, buf, 0, buf.length);
        }
        return buf;
    }

    public static void main(String[] args) {
        int i;
        Log log = new Log("keygenTest");
        RandomSource.getInstance().nextBoolean();
        byte[] src = new byte[200];
        RandomSource.getInstance().nextBytes(src);
        I2PAppContext ctx = new I2PAppContext();
        long time = 0L;
        for (int i2 = 0; i2 < 10; ++i2) {
            long start = Clock.getInstance().now();
            Object[] keys = KeyGenerator.getInstance().generatePKIKeypair();
            long end = Clock.getInstance().now();
            byte[] ctext = ctx.elGamalEngine().encrypt(src, (PublicKey)keys[0]);
            byte[] ptext = ctx.elGamalEngine().decrypt(ctext, (PrivateKey)keys[1]);
            time += end - start;
            if (DataHelper.eq(ptext, src)) {
                log.debug("D(E(data)) == data");
                continue;
            }
            log.error("D(E(data)) != data!!!!!!");
        }
        log.info("Keygen 10 times: " + time + "ms");
        Object[] obj = KeyGenerator.getInstance().generateSigningKeypair();
        SigningPublicKey fake = (SigningPublicKey)obj[0];
        time = 0L;
        for (i = 0; i < 10; ++i) {
            long start = Clock.getInstance().now();
            Object[] keys = KeyGenerator.getInstance().generateSigningKeypair();
            long end = Clock.getInstance().now();
            Signature sig = DSAEngine.getInstance().sign(src, (SigningPrivateKey)keys[1]);
            boolean ok = DSAEngine.getInstance().verifySignature(sig, src, (SigningPublicKey)keys[0]);
            boolean fakeOk = DSAEngine.getInstance().verifySignature(sig, src, fake);
            time += end - start;
            log.debug("V(S(data)) == " + ok + " fake verify correctly failed? " + !fakeOk);
        }
        log.info("Signing Keygen 10 times: " + time + "ms");
        time = 0L;
        for (i = 0; i < 1000; ++i) {
            long start = Clock.getInstance().now();
            KeyGenerator.getInstance().generateSessionKey();
            long end = Clock.getInstance().now();
            time += end - start;
        }
        log.info("Session keygen 1000 times: " + time + "ms");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }
}

