/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TransientSessionKeyManager;
import net.i2p.crypto.YKGenerator;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.util.Log;

public class PersistentSessionKeyManager
extends TransientSessionKeyManager {
    private Log _log;
    private Object _yk = YKGenerator.class;

    public PersistentSessionKeyManager(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(PersistentSessionKeyManager.class);
    }

    private PersistentSessionKeyManager() {
        this(null);
    }

    public void saveState(OutputStream out) throws IOException, DataFormatException {
    }

    public void loadState(InputStream in) throws IOException, DataFormatException {
        int inboundSets = (int)DataHelper.readLong(in, 4);
        HashSet<TransientSessionKeyManager.TagSet> tagSets = new HashSet<TransientSessionKeyManager.TagSet>(inboundSets);
        for (int i = 0; i < inboundSets; ++i) {
            TransientSessionKeyManager.TagSet ts = this.readTagSet(in);
            tagSets.add(ts);
        }
        int outboundSessions = (int)DataHelper.readLong(in, 4);
        HashSet<TransientSessionKeyManager.OutboundSession> sessions = new HashSet<TransientSessionKeyManager.OutboundSession>(outboundSessions);
        for (int i = 0; i < outboundSessions; ++i) {
            TransientSessionKeyManager.OutboundSession sess = this.readOutboundSession(in);
            sessions.add(sess);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Loading state with " + tagSets.size() + " inbound tagSets and " + sessions.size() + " outbound sessions");
        }
        this.setData(tagSets, sessions);
    }

    private void writeOutboundSession(OutputStream out, TransientSessionKeyManager.OutboundSession sess) throws IOException, DataFormatException {
        sess.getTarget().writeBytes(out);
        sess.getCurrentKey().writeBytes(out);
        DataHelper.writeDate(out, new Date(sess.getEstablishedDate()));
        DataHelper.writeDate(out, new Date(sess.getLastUsedDate()));
        List sets = sess.getTagSets();
        DataHelper.writeLong(out, 2, sets.size());
        for (TransientSessionKeyManager.TagSet set : sets) {
            this.writeTagSet(out, set);
        }
    }

    private void writeTagSet(OutputStream out, TransientSessionKeyManager.TagSet ts) throws IOException, DataFormatException {
        ts.getAssociatedKey().writeBytes(out);
        DataHelper.writeDate(out, new Date(ts.getDate()));
        DataHelper.writeLong(out, 2, ts.getTags().size());
        for (SessionTag tag : ts.getTags()) {
            out.write(tag.getData());
        }
    }

    private TransientSessionKeyManager.OutboundSession readOutboundSession(InputStream in) throws IOException, DataFormatException {
        PublicKey key = new PublicKey();
        key.readBytes(in);
        SessionKey skey = new SessionKey();
        skey.readBytes(in);
        Date established = DataHelper.readDate(in);
        Date lastUsed = DataHelper.readDate(in);
        int tagSets = (int)DataHelper.readLong(in, 2);
        ArrayList<TransientSessionKeyManager.TagSet> sets = new ArrayList<TransientSessionKeyManager.TagSet>(tagSets);
        for (int i = 0; i < tagSets; ++i) {
            TransientSessionKeyManager.TagSet ts = this.readTagSet(in);
            sets.add(ts);
        }
        return new TransientSessionKeyManager.OutboundSession(this, key, skey, established.getTime(), lastUsed.getTime(), sets);
    }

    private TransientSessionKeyManager.TagSet readTagSet(InputStream in) throws IOException, DataFormatException {
        SessionKey key = new SessionKey();
        key.readBytes(in);
        Date date = DataHelper.readDate(in);
        int numTags = (int)DataHelper.readLong(in, 2);
        HashSet<SessionTag> tags = new HashSet<SessionTag>(numTags);
        for (int i = 0; i < numTags; ++i) {
            SessionTag tag = new SessionTag();
            byte[] val = new byte[32];
            int read = DataHelper.read(in, val);
            if (read != 32) {
                throw new IOException("Unable to fully read a session tag [" + read + " not " + 32 + ")");
            }
            tag.setData(val);
            tags.add(tag);
        }
        TransientSessionKeyManager.TagSet ts = new TransientSessionKeyManager.TagSet(tags, key, this._context.clock().now());
        ts.setDate(date.getTime());
        return ts;
    }

    public static void main(String[] args) {
        I2PAppContext ctx = new I2PAppContext();
        Log log = ctx.logManager().getLog(PersistentSessionKeyManager.class);
        PersistentSessionKeyManager mgr = (PersistentSessionKeyManager)ctx.sessionKeyManager();
        try {
            mgr.loadState(new FileInputStream("sessionKeys.dat"));
            String state = mgr.renderStatusHTML();
            FileOutputStream fos = new FileOutputStream("sessionKeysBeforeExpire.html");
            fos.write(state.getBytes());
            fos.close();
            int expired = mgr.aggressiveExpire();
            log.error("Expired: " + expired);
            String stateAfter = mgr.renderStatusHTML();
            FileOutputStream fos2 = new FileOutputStream("sessionKeysAfterExpire.html");
            fos2.write(stateAfter.getBytes());
            fos2.close();
        }
        catch (Throwable t) {
            log.error("Error loading/storing sessionKeys", t);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }
}

