/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.i2p.crypto.SHA1;

public class SHA1Test {
    private static final SHA1 hash = new SHA1();
    private static final String HEX = "0123456789ABCDEF";

    public static void main(String[] args) {
        System.out.println("****************************************");
        System.out.println("* Basic FIPS PUB 180-1 test vectors... *");
        System.out.println("****************************************");
        SHA1Test.tst(1, 1, "abc", "A9993E36 4706816A BA3E2571 7850C26C 9CD0D89D");
        SHA1Test.tst(1, 2, "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "84983E44 1C3BD26e BAAE4AA1 F95129E5 E54670F1");
        SHA1Test.tst(1, 3, 1000000, "a", "34AA973C D4C4DAA4 F61EEB2B DBAD2731 6534016F");
        System.out.println();
        System.out.println("********************************************************");
        System.out.println("* SHSV Examples of the selected short messages test... *");
        System.out.println("********************************************************");
        SHA1Test.tst(2, 2, new byte[]{94}, "5e6f80a3 4a9798ca fc6a5db9 6cc57ba4 c4db59c2");
        SHA1Test.tst(2, 4, new byte[]{-102, 125, -3, -15, -20, -22, -48, 110, -42, 70, -86, 85, -2, 117, 113, 70}, "82abff66 05dbe1c1 7def12a3 94fa22a8 2b544a35");
        System.out.println();
        System.out.println("*******************************************************");
        System.out.println("* SHSV Examples of the selected long messages test... *");
        System.out.println("*******************************************************");
        SHA1Test.tst(3, 2, new byte[]{-9, -113, -110, 20, 27, -51, 23, 10, -24, -101, 79, -70, 21, -95, -43, -97, 63, -40, 77, 34, 60, -110, 81, -67, -84, -69, -82, 97, -48, 94, -47, 21, -96, 106, 124, -31, 23, -73, -66, -22, -46, 68, 33, -34, -39, -61, 37, -110, -67, 87, -19, -22, -29, -100, 57, -6, 31, -24, -108, 106, -124, -48, -49, 31, 123, -18, -83, 23, 19, -30, -32, -107, -104, -105, 52, 127, 103, -56, 11, 4, 0, -62, 9, -127, 93, 107, 16, -90, -125, -125, 111, -43, 86, 42, 86, -54, -79, -94, -114, -127, -74, 87, 102, 84, 99, 28, -15, 101, 102, -72, 110, 59, 51, -95, 8, -80, 83, 7, -64, 10, -1, 20, -89, 104, -19, 115, 80, 96, 106, 15, -123, -26, -87, 29, 57, 111, 91, 92, -66, 87, 127, -101, 56, -128, 124, 125, 82, 61, 109, 121, 47, 110, -68, 36, -92, -20, -14, -77, -92, 39, -51, -69, -5}, "cb0082c8 f197d260 991ba6a4 60e76e20 2bad27b3");
        System.out.println();
        int RETRIES = 10;
        int ITERATIONS = 2000;
        int BLOCKSIZE = 65536;
        byte[] input = new byte[65536];
        int i = 65536;
        while (--i >= 0) {
            input[i] = (byte)i;
        }
        long best = 0L;
        for (int i2 = 0; i2 < 1000; ++i2) {
            System.currentTimeMillis();
        }
        for (int retry = 0; retry < 10; ++retry) {
            long t0 = System.currentTimeMillis();
            int i3 = 2000;
            while (--i3 >= 0) {
            }
            long t1 = System.currentTimeMillis();
            int i4 = 2000;
            while (--i4 >= 0) {
                hash.engineUpdate(input, 0, 65536);
            }
            long t2 = System.currentTimeMillis();
            long time = t2 - t1 - (t1 - t0);
            if (retry != 0 && time >= best) continue;
            best = time;
        }
        hash.engineReset();
        double rate = 1.31072E11 / (double)best;
        System.out.println("Our rate = " + (float)(rate * 8.0) + " bits/s = " + (float)(rate / 1048576.0) + " Megabytes/s");
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            for (int retry = 0; retry < 10; ++retry) {
                long t0 = System.currentTimeMillis();
                int i5 = 2000;
                while (--i5 >= 0) {
                }
                long t1 = System.currentTimeMillis();
                int i6 = 2000;
                while (--i6 >= 0) {
                    md.update(input, 0, 65536);
                }
                long t2 = System.currentTimeMillis();
                long time = t2 - t1 - (t1 - t0);
                if (retry != 0 && time >= best) continue;
                best = time;
            }
            md.reset();
            rate = 1.31072E11 / (double)best;
            System.out.println("JCE rate = " + (float)(rate * 8.0) + " bits/s = " + (float)(rate / 1048576.0) + " Megabytes/s");
        }
        catch (NoSuchAlgorithmException nsae) {
            System.out.println("No SHA algorithm in local JCE Security Providers");
        }
    }

    private static final boolean tst(int set, int vector, String source, String expect) {
        byte[] input = new byte[source.length()];
        for (int i = 0; i < input.length; ++i) {
            input[i] = (byte)source.charAt(i);
        }
        return SHA1Test.tst(set, vector, input, expect);
    }

    private static final boolean tst(int set, int vector, byte[] input, String expect) {
        System.out.print("Set " + set + ", vector# " + vector + ": ");
        hash.engineUpdate(input, 0, input.length);
        return SHA1Test.tstResult(expect);
    }

    private static final boolean tst(int set, int vector, int times, String source, String expect) {
        int i;
        byte[] input = new byte[source.length()];
        for (i = 0; i < input.length; ++i) {
            input[i] = (byte)source.charAt(i);
        }
        System.out.print("Set " + set + ", vector# " + vector + ": ");
        for (i = 0; i < times; ++i) {
            hash.engineUpdate(input, 0, input.length);
        }
        return SHA1Test.tstResult(expect);
    }

    private static final boolean tstResult(String expect) {
        String result = SHA1Test.toHex(hash.engineDigest());
        if (!(expect = expect.toUpperCase()).equals(result)) {
            System.out.println("**************** WRONG ***************");
            System.out.println("  expect: " + expect);
            System.out.println("  result: " + result);
            return false;
        }
        System.out.println("OK");
        return true;
    }

    private static final String toHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((i & 3) == 0 && i != 0) {
                buf.append(' ');
            }
            buf.append(HEX.charAt(bytes[i] >> 4 & 0xF)).append(HEX.charAt(bytes[i] & 0xF));
        }
        return buf.toString();
    }
}

