/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.util.Log;

public class PublicKey
extends DataStructureImpl {
    private static final Log _log = new Log(PublicKey.class);
    private byte[] _data;
    public static final int KEYSIZE_BYTES = 256;

    public PublicKey() {
        this.setData(null);
    }

    public PublicKey(byte[] data) {
        if (data == null || data.length != 256) {
            throw new IllegalArgumentException("Data must be specified, and the correct size");
        }
        this.setData(data);
    }

    public PublicKey(String base64Data) throws DataFormatException {
        this();
        this.fromBase64(base64Data);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._data = new byte[256];
        int read = this.read(in, this._data);
        if (read != 256) {
            throw new DataFormatException("Not enough bytes to read the public key");
        }
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._data == null) {
            throw new DataFormatException("No data in the public key to write out");
        }
        if (this._data.length != 256) {
            throw new DataFormatException("Invalid size of data in the public key");
        }
        out.write(this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PublicKey)) {
            return false;
        }
        return DataHelper.eq(this._data, ((PublicKey)obj)._data);
    }

    public int hashCode() {
        return DataHelper.hashCode(this._data);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("[PublicKey: ");
        if (this._data == null) {
            buf.append("null key");
        } else {
            buf.append("size: ").append(this._data.length);
        }
        buf.append("]");
        return buf.toString();
    }
}

