/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.LeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.Log;

public class CreateLeaseSetMessage
extends I2CPMessageImpl {
    private static final Log _log = new Log(CreateLeaseSetMessage.class);
    public static final int MESSAGE_TYPE = 4;
    private SessionId _sessionId;
    private LeaseSet _leaseSet;
    private SigningPrivateKey _signingPrivateKey;
    private PrivateKey _privateKey;

    public CreateLeaseSetMessage() {
        this.setSessionId(null);
        this.setLeaseSet(null);
        this.setSigningPrivateKey(null);
        this.setPrivateKey(null);
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public SigningPrivateKey getSigningPrivateKey() {
        return this._signingPrivateKey;
    }

    public void setSigningPrivateKey(SigningPrivateKey key) {
        this._signingPrivateKey = key;
    }

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this._privateKey = privateKey;
    }

    public LeaseSet getLeaseSet() {
        return this._leaseSet;
    }

    public void setLeaseSet(LeaseSet leaseSet) {
        this._leaseSet = leaseSet;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            this._signingPrivateKey = new SigningPrivateKey();
            this._signingPrivateKey.readBytes(in);
            this._privateKey = new PrivateKey();
            this._privateKey.readBytes(in);
            this._leaseSet = new LeaseSet();
            this._leaseSet.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error reading the CreateLeaseSetMessage", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null || this._signingPrivateKey == null || this._privateKey == null || this._leaseSet == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        int size = 280 + this._leaseSet.size();
        ByteArrayOutputStream os = new ByteArrayOutputStream(size);
        try {
            this._sessionId.writeBytes(os);
            this._signingPrivateKey.writeBytes(os);
            this._privateKey.writeBytes(os);
            this._leaseSet.writeBytes(os);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 4;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CreateLeaseSetMessage) {
            CreateLeaseSetMessage msg = (CreateLeaseSetMessage)object;
            return DataHelper.eq(this.getSessionId(), msg.getSessionId()) && DataHelper.eq(this.getSigningPrivateKey(), msg.getSigningPrivateKey()) && DataHelper.eq(this.getPrivateKey(), msg.getPrivateKey()) && DataHelper.eq(this.getLeaseSet(), msg.getLeaseSet());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[CreateLeaseSetMessage: ");
        buf.append("\n\tLeaseSet: ").append(this.getLeaseSet());
        buf.append("\n\tSigningPrivateKey: ").append(this.getSigningPrivateKey());
        buf.append("\n\tPrivateKey: ").append(this.getPrivateKey());
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("]");
        return buf.toString();
    }
}

