/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.util.Log;

public class ReceiveMessageBeginMessage
extends I2CPMessageImpl {
    private static final Log _log = new Log(ReceiveMessageBeginMessage.class);
    public static final int MESSAGE_TYPE = 6;
    private long _sessionId;
    private long _messageId;

    public ReceiveMessageBeginMessage() {
        this.setSessionId(-1L);
        this.setMessageId(-1L);
    }

    public long getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(long id) {
        this._sessionId = id;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public void setMessageId(long id) {
        this._messageId = id;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = DataHelper.readLong(in, 2);
            this._messageId = DataHelper.readLong(in, 4);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        throw new UnsupportedOperationException("This shouldn't be called... use writeMessage(out)");
    }

    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        int len = 6;
        try {
            DataHelper.writeLong(out, 4, len);
            DataHelper.writeLong(out, 1, this.getType());
            DataHelper.writeLong(out, 2, this._sessionId);
            DataHelper.writeLong(out, 4, this._messageId);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to write the message length or type", dfe);
        }
    }

    public int getType() {
        return 6;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ReceiveMessageBeginMessage) {
            ReceiveMessageBeginMessage msg = (ReceiveMessageBeginMessage)object;
            return DataHelper.eq(this.getSessionId(), msg.getSessionId()) && DataHelper.eq(this.getMessageId(), msg.getMessageId());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ReceiveMessageBeginMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tMessageId: ").append(this.getMessageId());
        buf.append("]");
        return buf.toString();
    }
}

