/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

public class Frequency {
    private double _avgInterval;
    private double _minAverageInterval;
    private long _period;
    private long _lastEvent;
    private long _start = Frequency.now();
    private long _count = 0L;
    private Object _lock = this;

    public Frequency(long period) {
        this.setPeriod(period);
        this.setLastEvent(0L);
        this.setAverageInterval(0.0);
        this.setMinAverageInterval(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPeriod() {
        Object object = this._lock;
        synchronized (object) {
            return this._period;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastEvent() {
        Object object = this._lock;
        synchronized (object) {
            return this._lastEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverageInterval() {
        Object object = this._lock;
        synchronized (object) {
            return this._avgInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMinAverageInterval() {
        Object object = this._lock;
        synchronized (object) {
            return this._minAverageInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverageEventsPerPeriod() {
        Object object = this._lock;
        synchronized (object) {
            if (this._avgInterval > 0.0) {
                return (double)this._period / this._avgInterval;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaxAverageEventsPerPeriod() {
        Object object = this._lock;
        synchronized (object) {
            if (this._minAverageInterval > 0.0) {
                return (double)this._period / this._minAverageInterval;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStrictAverageInterval() {
        Object object = this._lock;
        synchronized (object) {
            long duration = Frequency.now() - this._start;
            if (duration <= 0L || this._count <= 0L) {
                return 0.0;
            }
            return (double)duration / (double)this._count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStrictAverageEventsPerPeriod() {
        double avgInterval = this.getStrictAverageInterval();
        Object object = this._lock;
        synchronized (object) {
            if (avgInterval > 0.0) {
                return (double)this._period / avgInterval;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEventCount() {
        Object object = this._lock;
        synchronized (object) {
            return this._count;
        }
    }

    public void eventOccurred() {
        this.recalculate(true);
    }

    public void recalculate() {
        this.recalculate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculate(boolean eventOccurred) {
        Object object = this._lock;
        synchronized (object) {
            long now = Frequency.now();
            long interval = now - this._lastEvent;
            if (interval >= this._period) {
                interval = this._period - 1L;
            } else if (interval <= 0L) {
                interval = 1L;
            }
            double oldWeight = 1.0f - (float)interval / (float)this._period;
            double newWeight = (float)interval / (float)this._period;
            double oldInterval = this._avgInterval * oldWeight;
            double newInterval = (double)interval * newWeight;
            this._avgInterval = oldInterval + newInterval;
            if (this._avgInterval < this._minAverageInterval || this._minAverageInterval <= 0.0) {
                this._minAverageInterval = this._avgInterval;
            }
            if (eventOccurred) {
                this._lastEvent = now;
                ++this._count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPeriod(long milliseconds) {
        Object object = this._lock;
        synchronized (object) {
            this._period = milliseconds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastEvent(long when) {
        Object object = this._lock;
        synchronized (object) {
            this._lastEvent = when;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAverageInterval(double msInterval) {
        Object object = this._lock;
        synchronized (object) {
            this._avgInterval = msInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMinAverageInterval(double minAverageInterval) {
        Object object = this._lock;
        synchronized (object) {
            this._minAverageInterval = minAverageInterval;
        }
    }

    private static final long now() {
        return System.currentTimeMillis();
    }
}

