/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import net.i2p.stat.Frequency;

public class FrequencyStat {
    private String _statName;
    private String _groupName;
    private String _description;
    private Frequency[] _frequencies;

    public FrequencyStat(String name, String description, String group, long[] periods) {
        this._statName = name;
        this._description = description;
        this._groupName = group;
        this._frequencies = new Frequency[periods.length];
        for (int i = 0; i < periods.length; ++i) {
            this._frequencies[i] = new Frequency(periods[i]);
        }
    }

    public void eventOccurred() {
        for (int i = 0; i < this._frequencies.length; ++i) {
            this._frequencies[i].eventOccurred();
        }
    }

    public void coalesceStats() {
    }

    public String getName() {
        return this._statName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public String getDescription() {
        return this._description;
    }

    public long[] getPeriods() {
        long[] rv = new long[this._frequencies.length];
        for (int i = 0; i < this._frequencies.length; ++i) {
            rv[i] = this._frequencies[i].getPeriod();
        }
        return rv;
    }

    public Frequency getFrequency(long period) {
        for (int i = 0; i < this._frequencies.length; ++i) {
            if (this._frequencies[i].getPeriod() != period) continue;
            return this._frequencies[i];
        }
        return null;
    }

    public int hashCode() {
        return this._statName.hashCode();
    }
}

