/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.util.EepGet;
import net.i2p.util.I2PThread;

public class EepGetScheduler
implements EepGet.StatusListener {
    private I2PAppContext _context;
    private List _urls;
    private List _localFiles;
    private String _proxyHost;
    private int _proxyPort;
    private int _curURL;
    private EepGet.StatusListener _listener;

    public EepGetScheduler(I2PAppContext ctx, List urls, List localFiles, String proxyHost, int proxyPort, EepGet.StatusListener lsnr) {
        this._context = ctx;
        this._urls = urls;
        this._localFiles = localFiles;
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._curURL = -1;
        this._listener = lsnr;
    }

    public void fetch() {
        I2PThread t = new I2PThread(new Runnable(){

            public void run() {
                EepGetScheduler.this.fetchNext();
            }
        }, "EepGetScheduler");
        t.setDaemon(true);
        t.start();
    }

    public void fetch(boolean shouldBlock) {
        if (shouldBlock) {
            while (this._curURL < this._urls.size()) {
                this.fetchNext();
            }
        } else {
            this.fetch();
        }
    }

    private void fetchNext() {
        ++this._curURL;
        if (this._curURL >= this._urls.size()) {
            return;
        }
        String url = (String)this._urls.get(this._curURL);
        String out = EepGet.suggestName(url);
        if (this._localFiles != null && this._localFiles.size() > this._curURL) {
            File f = (File)this._localFiles.get(this._curURL);
            out = f.getAbsolutePath();
        } else {
            if (this._localFiles == null) {
                this._localFiles = new ArrayList(this._urls.size());
            }
            this._localFiles.add(new File(out));
        }
        EepGet get = new EepGet(this._context, this._proxyHost != null && this._proxyPort > 0, this._proxyHost, this._proxyPort, 0, out, url);
        get.addStatusListener(this);
        get.fetch();
    }

    public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
        this._listener.attemptFailed(url, bytesTransferred, bytesRemaining, currentAttempt, numRetries, cause);
    }

    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        this._listener.bytesTransferred(alreadyTransferred, currentWrite, bytesTransferred, bytesRemaining, url);
    }

    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        this._listener.transferComplete(alreadyTransferred, bytesTransferred, bytesRemaining, url, outputFile, notModified);
        this.fetchNext();
    }

    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        this._listener.transferFailed(url, bytesTransferred, bytesRemaining, currentAttempt);
        this.fetchNext();
    }

    public void attempting(String url) {
        this._listener.attempting(url);
    }

    public void headerReceived(String url, int attemptNum, String key, String val) {
    }
}

