/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.i2p.util.SimpleTimer;

public class SocketTimeout
implements SimpleTimer.TimedEvent {
    private Socket _targetSocket;
    private long _startTime;
    private long _inactivityDelay;
    private long _lastActivity;
    private long _totalTimeoutTime;
    private boolean _cancelled;
    private Runnable _command;
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS");

    public SocketTimeout(long delay) {
        this(null, delay);
    }

    public SocketTimeout(Socket socket, long delay) {
        this._inactivityDelay = delay;
        this._targetSocket = socket;
        this._cancelled = false;
        this._lastActivity = this._startTime = System.currentTimeMillis();
        this._totalTimeoutTime = -1L;
        SimpleTimer.getInstance().addEvent(this, delay);
    }

    public void timeReached() {
        if (this._cancelled) {
            return;
        }
        if (this._totalTimeoutTime > 0L && this._totalTimeoutTime <= System.currentTimeMillis() || this._inactivityDelay + this._lastActivity <= System.currentTimeMillis()) {
            if (this._targetSocket != null) {
                try {
                    if (!this._targetSocket.isClosed()) {
                        this._targetSocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this._command != null) {
                this._command.run();
            }
        } else {
            SimpleTimer.getInstance().addEvent(this, this._inactivityDelay);
        }
    }

    public void cancel() {
        this._cancelled = true;
        SimpleTimer.getInstance().removeEvent(this);
    }

    public void setSocket(Socket s) {
        this._targetSocket = s;
    }

    public void resetTimer() {
        this._lastActivity = System.currentTimeMillis();
    }

    public void setInactivityTimeout(long timeout) {
        this._inactivityDelay = timeout;
    }

    public void setTotalTimeoutPeriod(long timeoutPeriod) {
        this._totalTimeoutTime = timeoutPeriod > 0L ? this._startTime + timeoutPeriod : -1L;
    }

    public void setTimeoutCommand(Runnable job) {
        this._command = job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ts(long when) {
        SimpleDateFormat simpleDateFormat = _fmt;
        synchronized (simpleDateFormat) {
            return _fmt.format(new Date(when));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("started on ");
        buf.append(SocketTimeout.ts(this._startTime));
        buf.append("idle for ");
        buf.append(System.currentTimeMillis() - this._lastActivity);
        buf.append("ms ");
        if (this._totalTimeoutTime > 0L) {
            buf.append("total timeout at ").append(SocketTimeout.ts(this._totalTimeoutTime));
        }
        buf.append("cancelled? ").append(this._cancelled);
        return buf.toString();
    }
}

