/*
 * Decompiled with CFR 0.152.
 */
package org.xlattice.crypto.filters;

import org.xlattice.crypto.filters.KeySelector;

public class BloomSHA1 {
    protected final int m;
    protected final int k;
    protected int count;
    protected final int[] filter;
    protected KeySelector ks;
    protected final int[] wordOffset;
    protected final int[] bitOffset;
    protected final int filterBits;
    protected final int filterWords;

    public static void main(String[] args) {
        BloomSHA1 b = new BloomSHA1(24, 11);
        for (int i = 0; i < 100; ++i) {
            byte[] v = new byte[32];
            v[0] = (byte)i;
            b.insert(v);
        }
    }

    public BloomSHA1(int m, int k) {
        this.m = m;
        this.k = k;
        this.count = 0;
        this.filterBits = 1 << m;
        this.filterWords = (this.filterBits + 31) / 32;
        this.filter = new int[this.filterWords];
        this.doClear();
        this.wordOffset = new int[k];
        this.bitOffset = new int[k];
        this.ks = new KeySelector(m, k, this.bitOffset, this.wordOffset);
    }

    public BloomSHA1(int m) {
        this(m, 8);
    }

    public BloomSHA1() {
        this(20, 8);
    }

    protected void doClear() {
        for (int i = 0; i < this.filterWords; ++i) {
            this.filter[i] = 0;
        }
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        BloomSHA1 bloomSHA1 = this;
        synchronized (bloomSHA1) {
            this.doClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        BloomSHA1 bloomSHA1 = this;
        synchronized (bloomSHA1) {
            return this.count;
        }
    }

    public final int capacity() {
        return this.filterBits;
    }

    public void insert(byte[] b) {
        this.insert(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(byte[] b, int offset, int len) {
        BloomSHA1 bloomSHA1 = this;
        synchronized (bloomSHA1) {
            this.locked_insert(b);
        }
    }

    public final void locked_insert(byte[] b) {
        this.locked_insert(b, 0, b.length);
    }

    public final void locked_insert(byte[] b, int offset, int len) {
        this.ks.getOffsets(b, offset, len);
        for (int i = 0; i < this.k; ++i) {
            int n = this.wordOffset[i];
            this.filter[n] = this.filter[n] | 1 << this.bitOffset[i];
        }
        ++this.count;
    }

    protected final boolean isMember(byte[] b) {
        return this.isMember(b, 0, b.length);
    }

    protected final boolean isMember(byte[] b, int offset, int len) {
        this.ks.getOffsets(b, offset, len);
        for (int i = 0; i < this.k; ++i) {
            if ((this.filter[this.wordOffset[i]] & 1 << this.bitOffset[i]) != 0) continue;
            return false;
        }
        return true;
    }

    public final boolean locked_member(byte[] b) {
        return this.isMember(b);
    }

    public final boolean locked_member(byte[] b, int offset, int len) {
        return this.isMember(b, offset, len);
    }

    public final boolean member(byte[] b) {
        return this.member(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean member(byte[] b, int offset, int len) {
        BloomSHA1 bloomSHA1 = this;
        synchronized (bloomSHA1) {
            return this.isMember(b, offset, len);
        }
    }

    public final double falsePositives(int n) {
        return Math.pow(1.0 - Math.exp(0.0 - (double)this.k * (double)n / (double)this.filterBits), this.k);
    }

    public final double falsePositives() {
        return this.falsePositives(this.count);
    }

    public static String keyToString(byte[] key) {
        StringBuffer sb = new StringBuffer().append(key[0]);
        for (int i = 1; i < key.length; ++i) {
            sb.append(".").append(Integer.toString(key[i], 16));
        }
        return sb.toString();
    }

    public static String ltoh(long i) {
        StringBuffer sb = new StringBuffer().append("#").append(Long.toString(i, 16));
        return sb.toString();
    }

    public static String itoh(int i) {
        StringBuffer sb = new StringBuffer().append("#").append(Integer.toString(i, 16));
        return sb.toString();
    }

    public static String btoh(byte b) {
        int i = 0xFF & b;
        return BloomSHA1.itoh(i);
    }
}

