/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import org.tanukisoftware.wrapper.WrapperManager;

public class WrapperActionServer
implements Runnable {
    public static final byte COMMAND_SHUTDOWN = 83;
    public static final byte COMMAND_HALT_EXPECTED = 72;
    public static final byte COMMAND_RESTART = 82;
    public static final byte COMMAND_DUMP = 68;
    public static final byte COMMAND_HALT_UNEXPECTED = 85;
    public static final byte COMMAND_ACCESS_VIOLATION = 86;
    public static final byte COMMAND_APPEAR_HUNG = 71;
    private InetAddress m_bindAddr;
    private int m_port;
    private Thread m_runner;
    private boolean m_runnerStop = false;
    private ServerSocket m_serverSocket;
    private Hashtable m_actions = new Hashtable();
    private static /* synthetic */ Class class$Ljava$lang$Runtime;

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void run() {
        if (Thread.currentThread() != this.m_runner) {
            throw new IllegalStateException("Private method.");
        }
        block19: while (true) {
            while (!this.m_runnerStop) {
                try {
                    void action;
                    void command;
                    Socket socket = this.m_serverSocket.accept();
                    try {
                        socket.setSoTimeout(15000);
                        int n = socket.getInputStream().read();
                    }
                    finally {
                        Object var8_5 = null;
                        socket.close();
                    }
                    if (command < 0) continue block19;
                    Hashtable hashtable = this.m_actions;
                    synchronized (hashtable) {
                        Runnable runnable = (Runnable)this.m_actions.get(new Integer((int)command));
                    }
                    if (action == null) continue block19;
                    try {
                        action.run();
                    }
                    catch (Throwable t) {
                        System.out.println("WrapperActionServer: Error processing action.");
                        t.printStackTrace();
                    }
                    continue block19;
                }
                catch (Throwable t) {
                    if (this.m_runnerStop && (t instanceof InterruptedException || t instanceof SocketException || t instanceof InterruptedIOException)) continue block19;
                    System.out.println("WrapperActionServer: Unexpeced error.");
                    t.printStackTrace();
                    try {
                        Thread.sleep(5000L);
                        continue block19;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            break;
        }
        Object var2_10 = null;
        WrapperActionServer wrapperActionServer = this;
        synchronized (wrapperActionServer) {
            this.m_runner = null;
            this.notify();
        }
        catch (Throwable throwable) {
            Object var2_11 = null;
            WrapperActionServer wrapperActionServer2 = this;
            synchronized (wrapperActionServer2) {
                this.m_runner = null;
                this.notify();
            }
            throw throwable;
        }
    }

    public void start() throws IOException {
        this.m_serverSocket = new ServerSocket(this.m_port, 5, this.m_bindAddr);
        this.m_runner = new Thread((Runnable)this, "WrapperActionServer_runner");
        this.m_runner.setDaemon(true);
        this.m_runner.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws Exception {
        Thread runner = this.m_runner;
        this.m_runnerStop = true;
        runner.interrupt();
        ServerSocket serverSocket = this.m_serverSocket;
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        WrapperActionServer wrapperActionServer = this;
        synchronized (wrapperActionServer) {
            while (true) {
                if (this.m_runner == null) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public void registerAction(byte command, Runnable action) {
        Hashtable hashtable = this.m_actions;
        synchronized (hashtable) {
            this.m_actions.put(new Integer(command), action);
        }
    }

    public void unregisterAction(byte command) {
        Hashtable hashtable = this.m_actions;
        synchronized (hashtable) {
            this.m_actions.remove(new Integer(command));
        }
    }

    public void enableShutdownAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)83, new Runnable(this){
                private final /* synthetic */ WrapperActionServer this$0;

                public final void run() {
                    WrapperManager.stop(0);
                }
                {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(WrapperActionServer wrapperActionServer) {
                }
            });
        } else {
            this.unregisterAction((byte)83);
        }
    }

    public void enableHaltExpectedAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)72, new Runnable(this){
                private final /* synthetic */ WrapperActionServer this$0;

                public final void run() {
                    WrapperManager.stopImmediate(0);
                }
                {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(WrapperActionServer wrapperActionServer) {
                }
            });
        } else {
            this.unregisterAction((byte)72);
        }
    }

    public void enableRestartAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)82, new Runnable(this){
                private final /* synthetic */ WrapperActionServer this$0;

                public final void run() {
                    WrapperManager.restart();
                }
                {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(WrapperActionServer wrapperActionServer) {
                }
            });
        } else {
            this.unregisterAction((byte)82);
        }
    }

    public void enableThreadDumpAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)68, new Runnable(this){
                private final /* synthetic */ WrapperActionServer this$0;

                public final void run() {
                    WrapperManager.requestThreadDump();
                }
                {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(WrapperActionServer wrapperActionServer) {
                }
            });
        } else {
            this.unregisterAction((byte)68);
        }
    }

    public void enableHaltUnexpectedAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)85, new Runnable(this){
                private final /* synthetic */ WrapperActionServer this$0;

                public final void run() {
                    Method haltMethod;
                    try {
                        Class clazz;
                        if (WrapperActionServer.access$1() != null) {
                            clazz = WrapperActionServer.access$1();
                        } else {
                            Class clazz2 = WrapperActionServer.class$("java.lang.Runtime");
                            clazz = clazz2;
                            WrapperActionServer.access$0(clazz2);
                        }
                        Method method = clazz.getMethod("halt", Integer.TYPE);
                    }
                    catch (NoSuchMethodException e) {
                        System.out.println("halt not supported by current JVM.");
                        haltMethod = null;
                    }
                    if (haltMethod != null) {
                        Runtime runtime = Runtime.getRuntime();
                        try {
                            haltMethod.invoke((Object)runtime, new Integer(0));
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Unable to call runitme.halt: " + e.getMessage());
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Unable to call runitme.halt: " + e.getMessage());
                        }
                    }
                }
                {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(WrapperActionServer wrapperActionServer) {
                }
            });
        } else {
            this.unregisterAction((byte)85);
        }
    }

    public void enableAccessViolationAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)86, new Runnable(this){
                private final /* synthetic */ WrapperActionServer this$0;

                public final void run() {
                    WrapperManager.accessViolationNative();
                }
                {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(WrapperActionServer wrapperActionServer) {
                }
            });
        } else {
            this.unregisterAction((byte)86);
        }
    }

    public void enableAppearHungAction(boolean enable) {
        if (enable) {
            this.registerAction((byte)71, new Runnable(this){
                private final /* synthetic */ WrapperActionServer this$0;

                public final void run() {
                    WrapperManager.appearHung();
                }
                {
                    this.this$0 = this$0;
                    this.constructor$0(this$0);
                }

                private final void constructor$0(WrapperActionServer wrapperActionServer) {
                }
            });
        } else {
            this.unregisterAction((byte)71);
        }
    }

    static /* synthetic */ void access$0(Class clazz) {
        class$Ljava$lang$Runtime = clazz;
    }

    static /* synthetic */ Class access$1() {
        return class$Ljava$lang$Runtime;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public WrapperActionServer(int port, InetAddress bindAddress) {
        this.m_port = port;
        this.m_bindAddr = bindAddress;
    }

    public WrapperActionServer(int port) {
        this(port, null);
    }
}

