/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.Log;

class BufferLogger
implements Logging {
    private static final Log _log = new Log(BufferLogger.class);
    private ByteArrayOutputStream _baos = new ByteArrayOutputStream(512);
    private boolean _ignore = false;
    private static final String EMPTY = "";

    public String getBuffer() {
        if (this._ignore) {
            return EMPTY;
        }
        return new String(this._baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreFurtherActions() {
        this._ignore = true;
        ByteArrayOutputStream byteArrayOutputStream = this._baos;
        synchronized (byteArrayOutputStream) {
            this._baos.reset();
        }
        this._baos = null;
    }

    public void log(String s) {
        if (this._ignore) {
            return;
        }
        if (s != null) {
            _log.debug("logging [" + s + "]");
            try {
                this._baos.write(s.getBytes());
                this._baos.write(10);
            }
            catch (IOException ioe) {
                _log.error("Error logging [" + s + "]");
            }
        }
    }
}

