/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.DataFormatException;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.util.Log;

public abstract class SOCKSServer {
    private static final Log _log = new Log(SOCKSServer.class);
    protected String connHostName = null;
    protected int connPort = 0;
    I2PSocket destSocket = null;
    Object FIXME = new Object();

    protected abstract void setupServer() throws SOCKSException;

    public abstract Socket getClientSocket() throws SOCKSException;

    protected abstract void confirmConnection() throws SOCKSException;

    public I2PSocket getDestinationI2PSocket() throws SOCKSException {
        I2PSocket destSock;
        this.setupServer();
        if (this.connHostName == null) {
            _log.error("BUG: destination host name has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        if (this.connPort == 0) {
            _log.error("BUG: destination port has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        try {
            if (!this.connHostName.toLowerCase().endsWith(".i2p")) {
                _log.error("We don't support outproxies (yet)");
                throw new SOCKSException("Ouproxies not supported (yet)");
            }
            _log.debug("connecting to " + this.connHostName + "...");
            I2PSocketManager sm = I2PSocketManagerFactory.createManager();
            destSock = sm.connect(I2PTunnel.destFromName(this.connHostName), null);
            this.confirmConnection();
            _log.debug("connection confirmed - exchanging data...");
        }
        catch (DataFormatException e) {
            throw new SOCKSException("Error in destination format");
        }
        catch (SocketException e) {
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        catch (I2PException e) {
            throw new SOCKSException("Error connecting (" + e.getMessage() + ")");
        }
        return destSock;
    }
}

