/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import net.i2p.i2ptunnel.socks.SOCKS5Server;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.util.Log;

public class SOCKSServerFactory {
    private static final Log _log = new Log(SOCKSServerFactory.class);

    public static SOCKSServer createSOCKSServer(Socket s) throws SOCKSException {
        SOCKS5Server serv;
        try {
            DataInputStream in = new DataInputStream(s.getInputStream());
            byte socksVer = in.readByte();
            switch (socksVer) {
                case 5: {
                    serv = new SOCKS5Server(s);
                    break;
                }
                default: {
                    _log.debug("SOCKS protocol version not supported (" + Integer.toHexString(socksVer) + ")");
                    return null;
                }
            }
        }
        catch (IOException e) {
            _log.debug("error reading SOCKS protocol version");
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
        return serv;
    }
}

