/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.WrapperInfo;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperUser;
import org.tanukisoftware.wrapper.resources.ResourceManager;

public final class WrapperManager
implements Runnable {
    private static final String WRAPPER_CONNECTION_THREAD_NAME = "Wrapper-Connection";
    private static final int DEFAULT_PORT = 15003;
    private static final int DEFAULT_SO_TIMEOUT = 10000;
    private static final long DEFAULT_CPU_TIMEOUT = 10000L;
    private static final int TICK_MS = 100;
    private static final int TIMER_FAST_THRESHOLD = 1728000;
    private static final int TIMER_SLOW_THRESHOLD = 1728000;
    private static final byte WRAPPER_MSG_START = 100;
    private static final byte WRAPPER_MSG_STOP = 101;
    private static final byte WRAPPER_MSG_RESTART = 102;
    private static final byte WRAPPER_MSG_PING = 103;
    private static final byte WRAPPER_MSG_STOP_PENDING = 104;
    private static final byte WRAPPER_MSG_START_PENDING = 105;
    private static final byte WRAPPER_MSG_STARTED = 106;
    private static final byte WRAPPER_MSG_STOPPED = 107;
    private static final byte WRAPPER_MSG_KEY = 110;
    private static final byte WRAPPER_MSG_BADKEY = 111;
    private static final byte WRAPPER_MSG_LOW_LOG_LEVEL = 112;
    private static final byte WRAPPER_MSG_PING_TIMEOUT = 113;
    private static final byte WRAPPER_MSG_LOG = 116;
    public static final int WRAPPER_CTRL_C_EVENT = 200;
    public static final int WRAPPER_CTRL_CLOSE_EVENT = 201;
    public static final int WRAPPER_CTRL_LOGOFF_EVENT = 202;
    public static final int WRAPPER_CTRL_SHUTDOWN_EVENT = 203;
    public static final int WRAPPER_LOG_LEVEL_DEBUG = 1;
    public static final int WRAPPER_LOG_LEVEL_INFO = 2;
    public static final int WRAPPER_LOG_LEVEL_STATUS = 3;
    public static final int WRAPPER_LOG_LEVEL_WARN = 4;
    public static final int WRAPPER_LOG_LEVEL_ERROR = 5;
    public static final int WRAPPER_LOG_LEVEL_FATAL = 6;
    public static final int WRAPPER_LOG_LEVEL_ADVICE = 7;
    private static PrintStream m_out;
    private static PrintStream m_err;
    private static boolean m_disposed;
    private static boolean m_started;
    private static WrapperManager m_instance;
    private static Thread m_hook;
    private static boolean m_hookTriggered;
    private static boolean m_shutdownJVMComplete;
    private static String[] m_args;
    private static int m_port;
    private static String m_key;
    private static int m_soTimeout;
    private static long m_cpuTimeout;
    private static int m_systemThreadCount;
    private static int m_lowLogLevel;
    private static int m_pingTimeout;
    private static boolean m_ignoreSignals;
    private static Thread m_commRunner;
    private static boolean m_commRunnerStarted;
    private static Thread m_eventRunner;
    private static int m_eventRunnerTicks;
    private static boolean m_useSystemTime;
    private static int m_timerFastThreshold;
    private static int m_timerSlowThreshold;
    private static volatile int m_ticks;
    private static WrapperListener m_listener;
    private static int m_lastPingTicks;
    private static ServerSocket m_serverSocket;
    private static Socket m_socket;
    private static boolean m_shuttingDown;
    private static boolean m_appearHung;
    private static Method m_addShutdownHookMethod;
    private static Method m_removeShutdownHookMethod;
    private static boolean m_service;
    private static boolean m_debug;
    private static int m_jvmId;
    private static boolean m_stopping;
    private static Thread m_stoppingThread;
    private static boolean m_libraryOK;
    private static byte[] m_commandBuffer;
    private static ResourceManager m_res;
    private static ResourceManager m_error;
    private static ResourceManager m_warning;
    private static ResourceManager m_info;
    static /* synthetic */ Class class$org$tanukisoftware$wrapper$WrapperManager;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    private static native void nativeInit(boolean var0);

    private static native String nativeGetLibraryVersion();

    private static native int nativeGetControlEvent();

    private static native void nativeRequestThreadDump();

    private static native void accessViolationInner();

    private static native void nativeSetConsoleTitle(byte[] var0);

    private static native WrapperUser nativeGetUser(boolean var0);

    private static native WrapperUser nativeGetInteractiveUser(boolean var0);

    private static int getIntProperty(String name, int defaultValue) {
        String val = System.getProperty(name);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static int getSystemTicks() {
        return (int)(System.currentTimeMillis() / 100L);
    }

    private static int getTicks() {
        if (m_useSystemTime) {
            return WrapperManager.getSystemTicks();
        }
        return m_ticks;
    }

    private static long getTickAge(int start, int end) {
        return (long)(end - start) * 100L;
    }

    private static boolean loadNativeLibrary(String name, String file) {
        try {
            System.loadLibrary(name);
            if (m_debug) {
                m_out.println("Loaded native library: " + file);
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            if (m_debug) {
                m_out.println("Loading native library failed: " + file + "  Cause: " + e);
            }
            return false;
        }
    }

    private static File locateFileOnPath(String file, String path) {
        String pathSep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(path, pathSep);
        while (st.hasMoreTokens()) {
            File libFile = new File(new File(st.nextToken()), file);
            if (!libFile.exists()) continue;
            return libFile;
        }
        return null;
    }

    private static void initializeNativeLibrary() {
        String libraryTail;
        String libraryHead;
        String osName;
        String baseName = System.getProperty("wrapper.native_library");
        if (baseName == null) {
            m_out.println("WARNING - The wrapper.native_library system property was not");
            m_out.println("          set. Using the default value, 'wrapper'.");
            baseName = "wrapper";
        }
        if ((osName = System.getProperty("os.name")).indexOf("Windows") >= 0) {
            libraryHead = "";
            libraryTail = ".dll";
        } else if (osName.indexOf("Mac") >= 0) {
            libraryHead = "lib";
            libraryTail = ".jnilib";
        } else {
            libraryHead = "lib";
            libraryTail = ".so";
        }
        String file = libraryHead + baseName + libraryTail;
        if (WrapperManager.loadNativeLibrary(baseName, file)) {
            m_libraryOK = true;
            if (m_debug) {
                m_out.println("Calling native initialization method.");
            }
            WrapperManager.nativeInit(m_debug);
        } else {
            m_libraryOK = false;
            String libPath = System.getProperty("java.library.path");
            m_out.println();
            if (libPath.equals("")) {
                m_out.println("WARNING - Unable to load the Wrapper's native library because the");
                m_out.println("          java.library.path was set to ''.  Please see the");
                m_out.println("          documentation for the wrapper.java.library.path ");
                m_out.println("          configuration property.");
            } else {
                File libFile = WrapperManager.locateFileOnPath(file, libPath);
                if (libFile == null) {
                    m_out.println("WARNING - Unable to load the Wrapper's native library because the file");
                    m_out.println("          '" + file + "' could not be located in the following");
                    m_out.println("          java.library.path:");
                    String pathSep = System.getProperty("path.separator");
                    StringTokenizer st = new StringTokenizer(libPath, pathSep);
                    while (st.hasMoreTokens()) {
                        File pathElement = new File(st.nextToken());
                        m_out.println("            " + pathElement.getAbsolutePath());
                    }
                    m_out.println("          Please see the documentation for the wrapper.java.library.path");
                    m_out.println("          configuration property.");
                } else {
                    m_out.println("WARNING - Unable to load the Wrapper's native library '" + file + "'.");
                    m_out.println("          The file is located on the path at the following location but");
                    m_out.println("          could not be loaded:");
                    m_out.println("            " + libFile.getAbsolutePath());
                    m_out.println("          Please verify that the file is readable by the current user");
                    m_out.println("          and that the file has not been corrupted in any way.");
                }
            }
            m_out.println("          System signals will not be handled correctly.");
            m_out.println();
        }
    }

    private static void verifyWrapperVersion() {
        if (!WrapperManager.isControlledByNativeWrapper()) {
            return;
        }
        String wrapperVersion = System.getProperty("wrapper.version");
        if (wrapperVersion == null) {
            wrapperVersion = "unknown";
        }
        if (!WrapperInfo.getVersion().equals(wrapperVersion)) {
            m_out.println("WARNING - The Wrapper jar file currently in use is version \"" + WrapperInfo.getVersion() + "\"");
            m_out.println("          while the version of the Wrapper which launched this JVM is ");
            m_out.println("          \"" + wrapperVersion + "\".");
            m_out.println("          The Wrapper may appear to work correctly but some features may");
            m_out.println("          not function correctly.  This configuration has not been tested");
            m_out.println("          and is not supported.");
            m_out.println();
        }
    }

    private static void verifyNativeLibraryVersion() {
        String jniVersion;
        if (!m_libraryOK) {
            return;
        }
        try {
            jniVersion = WrapperManager.nativeGetLibraryVersion();
        }
        catch (Throwable e) {
            if (m_debug) {
                m_out.println("Call to nativeGetLibraryVersion() failed: " + e);
            }
            jniVersion = "unknown";
        }
        if (!WrapperInfo.getVersion().equals(jniVersion)) {
            m_out.println("WARNING - The Wrapper jar file currently in use is version \"" + WrapperInfo.getVersion() + "\"");
            m_out.println("          while the version of the native library is \"" + jniVersion + "\".");
            m_out.println("          The Wrapper may appear to work correctly but some features may");
            m_out.println("          not function correctly.  This configuration has not been tested");
            m_out.println("          and is not supported.");
            m_out.println();
        }
    }

    private static boolean getBooleanProperty(String name) {
        return System.getProperty(name) != null;
    }

    public static String getVersion() {
        return WrapperInfo.getVersion();
    }

    public static String getBuildTime() {
        return WrapperInfo.getBuildTime();
    }

    public static int getJVMId() {
        return m_jvmId;
    }

    public static void setConsoleTitle(String title) {
        if (m_libraryOK) {
            byte[] titleBytes = title.getBytes();
            byte[] nullTermBytes = new byte[titleBytes.length + 1];
            System.arraycopy(titleBytes, 0, nullTermBytes, 0, titleBytes.length);
            nullTermBytes[titleBytes.length] = 0;
            WrapperManager.nativeSetConsoleTitle(nullTermBytes);
        }
    }

    public static WrapperUser getUser(boolean groups) {
        WrapperUser user = null;
        if (m_libraryOK) {
            user = WrapperManager.nativeGetUser(groups);
        }
        return user;
    }

    public static WrapperUser getInteractiveUser(boolean groups) {
        WrapperUser user = null;
        if (m_libraryOK) {
            user = WrapperManager.nativeGetInteractiveUser(groups);
        }
        return user;
    }

    public static void requestThreadDump() {
        if (m_libraryOK) {
            WrapperManager.nativeRequestThreadDump();
        } else {
            m_out.println("  wrapper library not loaded.");
        }
    }

    public static void appearHung() {
        m_out.println("WARNING: Making JVM appear to be hung...");
        m_appearHung = true;
    }

    public static void accessViolation() {
        block3: {
            m_out.println("WARNING: Attempting to cause an access violation...");
            try {
                Class<?> c = Class.forName("java.lang.String");
                Method method = c.getDeclaredMethod(null, null);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Exception ex) {
                if (ex instanceof NoSuchFieldException) break block3;
                ex.printStackTrace();
            }
        }
        m_out.println("  Attempt to cause access violation failed.  JVM is still alive.");
    }

    public static void accessViolationNative() {
        m_out.println("WARNING: Attempting to cause an access violation...");
        if (m_libraryOK) {
            WrapperManager.accessViolationInner();
            m_out.println("  Attempt to cause access violation failed.  JVM is still alive.");
        } else {
            m_out.println("  wrapper library not loaded.");
        }
    }

    public static boolean isControlledByNativeWrapper() {
        return m_key != null;
    }

    public static boolean isLaunchedAsService() {
        return m_service;
    }

    public static boolean isDebugEnabled() {
        return m_debug;
    }

    public static synchronized void start(WrapperListener listener, String[] args) {
        m_out.println("Wrapper (Version " + WrapperManager.getVersion() + ") http://wrapper.tanukisoftware.org");
        m_out.println();
        if (m_debug) {
            StringBuffer sb = new StringBuffer();
            sb.append("args[");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"");
                sb.append(args[i]);
                sb.append("\"");
            }
            sb.append("]");
            m_out.println("WrapperManager.start(" + listener + ", " + sb.toString() + ") " + "called by thread: " + Thread.currentThread().getName());
        }
        if (m_disposed) {
            throw new IllegalStateException("WrapperManager has already been disposed.");
        }
        if (m_listener != null) {
            throw new IllegalStateException("WrapperManager has already been started with a WrapperListener.");
        }
        if (listener == null) {
            throw new IllegalStateException("A WrapperListener must be specified.");
        }
        m_listener = listener;
        m_args = args;
        WrapperManager.startRunner();
        if (!WrapperManager.isControlledByNativeWrapper()) {
            WrapperManager.startInner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restart() {
        boolean stopping;
        if (m_debug) {
            m_out.println("WrapperManager.restart() called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager wrapperManager = m_instance;
        synchronized (wrapperManager) {
            stopping = m_stopping;
            if (!stopping) {
                m_stopping = true;
            }
        }
        if (!stopping) {
            if (!m_commRunnerStarted) {
                WrapperManager.startRunner();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            WrapperManager.sendCommand((byte)102, "restart");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        WrapperManager.stopInner(0);
    }

    public static void stop(int exitCode) {
        if (m_debug) {
            m_out.println("WrapperManager.stop(" + exitCode + ") called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager.stopCommon(exitCode, 1000);
        WrapperManager.stopInner(exitCode);
    }

    public static void stopImmediate(int exitCode) {
        Method haltMethod;
        if (m_debug) {
            m_out.println("WrapperManager.stopImmediate(" + exitCode + ") called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager.stopCommon(exitCode, 250);
        WrapperManager.signalStopped(exitCode);
        try {
            haltMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = WrapperManager.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("halt", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            m_out.println("halt not supported by current JVM.");
            haltMethod = null;
        }
        if (haltMethod != null) {
            Runtime runtime = Runtime.getRuntime();
            try {
                haltMethod.invoke((Object)runtime, new Integer(0));
            }
            catch (IllegalAccessException e) {
                m_out.println("Unable to call runtime.halt: " + e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t == null) {
                    t = e;
                }
                m_out.println("Unable to call runtime.halt: " + t);
            }
        } else {
            WrapperManager.stopInner(exitCode);
        }
    }

    public static void signalStarting(int waitHint) {
        WrapperManager.sendCommand((byte)105, Integer.toString(waitHint));
    }

    public static void signalStopping(int waitHint) {
        m_stopping = true;
        WrapperManager.sendCommand((byte)104, Integer.toString(waitHint));
    }

    public static void signalStopped(int exitCode) {
        m_stopping = true;
        WrapperManager.sendCommand((byte)107, Integer.toString(exitCode));
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean hasShutdownHookBeenTriggered() {
        return m_hookTriggered;
    }

    public static void log(int logLevel, String message) {
        if (logLevel < 1 || logLevel > 7) {
            throw new IllegalArgumentException("The specified logLevel is not valid.");
        }
        if (message == null) {
            throw new IllegalArgumentException("The message parameter can not be null.");
        }
        if (m_lowLogLevel <= logLevel) {
            WrapperManager.sendCommand((byte)(116 + logLevel), message);
        }
    }

    private WrapperManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopCommon(int exitCode, int delay) {
        boolean stopping;
        WrapperManager wrapperManager = m_instance;
        synchronized (wrapperManager) {
            stopping = m_stopping;
            if (!stopping) {
                m_stopping = true;
            }
        }
        if (!stopping) {
            if (!m_commRunnerStarted) {
                WrapperManager.startRunner();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            WrapperManager.sendCommand((byte)101, Integer.toString(exitCode));
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispose() {
        Class<?> clazz = m_instance.getClass();
        synchronized (clazz) {
            m_disposed = true;
            WrapperManager.closeSocket();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void startInner() {
        int oldPriority = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(5);
        if (m_debug) {
            m_out.println("calling listener.start()");
        }
        if (m_listener != null) {
            try {
                Integer result = m_listener.start(m_args);
                if (result != null) {
                    int exitCode = result;
                    WrapperManager.stop(exitCode);
                    return;
                }
            }
            catch (Throwable t) {
                m_out.println("Error in WrapperListener.start callback.  " + t);
                t.printStackTrace();
                WrapperManager.stopInner(1);
                return;
            }
        }
        if (m_debug) {
            m_out.println("returned from listener.start()");
        }
        Thread.currentThread().setPriority(oldPriority);
        WrapperManager.signalStarted();
    }

    private static void shutdownJVM(int exitCode) {
        if (Thread.currentThread() == m_hook) {
            WrapperManager.signalStopped(0);
            WrapperManager.dispose();
            m_shutdownJVMComplete = true;
        } else {
            if (!m_hookTriggered && m_hook != null) {
                try {
                    m_removeShutdownHookMethod.invoke((Object)Runtime.getRuntime(), m_hook);
                }
                catch (IllegalAccessException e) {
                    m_out.println("Wrapper Manager: Unable to unregister shutdown hook: " + e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t == null) {
                        t = e;
                    }
                    m_out.println("Wrapper Manager: Unable to unregister shutdown hook: " + t);
                }
            }
            WrapperManager.signalStopped(0);
            WrapperManager.dispose();
            if (m_debug) {
                m_out.println("calling System.exit(" + exitCode + ")");
            }
            m_shutdownJVMComplete = true;
            System.exit(exitCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopInner(int exitCode) {
        boolean block;
        WrapperManager wrapperManager = m_instance;
        synchronized (wrapperManager) {
            m_stopping = true;
            if (m_stoppingThread == null) {
                m_stoppingThread = Thread.currentThread();
                block = false;
            } else {
                if (Thread.currentThread() == m_stoppingThread) {
                    throw new IllegalStateException("WrapperManager.stop() can not be called recursively.");
                }
                block = true;
            }
        }
        if (block) {
            if (m_debug) {
                m_out.println("Thread, " + Thread.currentThread().getName() + ", waiting for the JVM to exit.");
            }
            int loops = 0;
            int wait = 50;
            while (true) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (Thread.currentThread() == m_hook && (m_shutdownJVMComplete || loops > 5000 / wait)) {
                    if (!m_shutdownJVMComplete && m_debug) {
                        m_out.println("Thread, " + Thread.currentThread().getName() + ", continuing after 5 seconds.");
                    }
                    return;
                }
                ++loops;
            }
        }
        if (m_debug) {
            m_out.println("Thread, " + Thread.currentThread().getName() + ", handling the shutdown process.");
        }
        int code = exitCode;
        if (m_started) {
            int oldPriority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(5);
            if (m_debug) {
                m_out.println("calling listener.stop()");
            }
            if (m_listener != null) {
                try {
                    code = m_listener.stop(code);
                }
                catch (Throwable t) {
                    m_out.println("Error in WrapperListener.stop callback.  " + t);
                    t.printStackTrace();
                }
            }
            if (m_debug) {
                m_out.println("returned from listener.stop()");
            }
            Thread.currentThread().setPriority(oldPriority);
        }
        WrapperManager.shutdownJVM(code);
    }

    private static void signalStarted() {
        WrapperManager.sendCommand((byte)106, "");
        m_started = true;
    }

    private static void controlEvent(int event) {
        boolean ignore;
        String eventName;
        switch (event) {
            case 200: {
                eventName = "WRAPPER_CTRL_C_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 201: {
                eventName = "WRAPPER_CTRL_CLOSE_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 202: {
                eventName = "WRAPPER_CTRL_LOGOFF_EVENT";
                ignore = false;
                break;
            }
            case 203: {
                eventName = "WRAPPER_CTRL_SHUTDOWN_EVENT";
                ignore = false;
                break;
            }
            default: {
                eventName = "Unexpected event: " + event;
                ignore = false;
            }
        }
        if (ignore) {
            if (m_debug) {
                m_out.println("Ignoring control event(" + eventName + ")");
            }
        } else {
            if (m_debug) {
                m_out.println("Processing control event(" + eventName + ")");
            }
            if (m_listener != null) {
                try {
                    m_listener.controlEvent(event);
                }
                catch (Throwable t) {
                    m_out.println("Error in WrapperListener.controlEvent callback.  " + t);
                    t.printStackTrace();
                }
            } else {
                WrapperManager.stop(0);
            }
        }
    }

    private static synchronized Socket openSocket() {
        InetAddress iNetAddress;
        if (m_debug) {
            m_out.println("Open socket to wrapper...");
        }
        try {
            iNetAddress = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            m_out.println(e);
            WrapperManager.stop(1);
            return null;
        }
        try {
            m_socket = new Socket(iNetAddress, m_port);
            if (m_debug) {
                m_out.println("Opened Socket");
            }
        }
        catch (BindException e) {
            m_out.println("Failed to bind to the Wrapper port.");
            m_out.println(e);
            m_out.println("Exiting JVM...");
            WrapperManager.stopImmediate(1);
        }
        catch (ConnectException e) {
            m_out.println("Failed to connect to the Wrapper.");
            m_out.println(e);
            m_out.println("Exiting JVM...");
            WrapperManager.stopImmediate(1);
        }
        catch (IOException e) {
            m_out.println(e);
            m_socket = null;
            return null;
        }
        try {
            m_socket.setTcpNoDelay(true);
            if (m_soTimeout > 0) {
                m_socket.setSoTimeout(m_soTimeout);
            }
        }
        catch (IOException e) {
            m_out.println(e);
        }
        WrapperManager.sendCommand((byte)110, m_key);
        return m_socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void closeSocket() {
        if (m_socket != null) {
            if (m_debug) {
                m_out.println("Closing socket.");
            }
            try {
                m_socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                m_socket = null;
            }
        }
    }

    private static String getPacketCodeName(byte code) {
        String name;
        switch (code) {
            case 100: {
                name = "START";
                break;
            }
            case 101: {
                name = "STOP";
                break;
            }
            case 102: {
                name = "RESTART";
                break;
            }
            case 103: {
                name = "PING";
                break;
            }
            case 104: {
                name = "STOP_PENDING";
                break;
            }
            case 105: {
                name = "START_PENDING";
                break;
            }
            case 106: {
                name = "STARTED";
                break;
            }
            case 107: {
                name = "STOPPED";
                break;
            }
            case 110: {
                name = "KEY";
                break;
            }
            case 111: {
                name = "BADKEY";
                break;
            }
            case 112: {
                name = "LOW_LOG_LEVEL";
                break;
            }
            case 113: {
                name = "PING_TIMEOUT";
                break;
            }
            case 117: {
                name = "LOG(DEBUG)";
                break;
            }
            case 118: {
                name = "LOG(INFO)";
                break;
            }
            case 119: {
                name = "LOG(STATUS)";
                break;
            }
            case 120: {
                name = "LOG(WARN)";
                break;
            }
            case 121: {
                name = "LOG(ERROR)";
                break;
            }
            case 122: {
                name = "LOG(FATAL)";
                break;
            }
            case 123: {
                name = "LOG(ADVICE)";
                break;
            }
            default: {
                name = "UNKNOWN(" + code + ")";
            }
        }
        return name;
    }

    private static synchronized void sendCommand(byte code, String message) {
        if (m_debug) {
            m_out.println("Send a packet " + WrapperManager.getPacketCodeName(code) + " : " + message);
        }
        if (!m_appearHung) {
            Socket socket = m_socket;
            if (socket == null && WrapperManager.isControlledByNativeWrapper() && !m_stopping) {
                socket = WrapperManager.openSocket();
            }
            if (code == 105 || code == 106) {
                m_lastPingTicks = WrapperManager.getTicks();
            }
            if (socket != null) {
                try {
                    byte[] messageBytes = message.getBytes();
                    if (m_commandBuffer.length < messageBytes.length + 2) {
                        m_commandBuffer = new byte[messageBytes.length + 2];
                    }
                    WrapperManager.m_commandBuffer[0] = code;
                    System.arraycopy(messageBytes, 0, m_commandBuffer, 1, messageBytes.length);
                    int len = messageBytes.length + 2;
                    WrapperManager.m_commandBuffer[len - 1] = 0;
                    OutputStream os = socket.getOutputStream();
                    os.write(m_commandBuffer, 0, len);
                    os.flush();
                }
                catch (IOException e) {
                    m_out.println(e);
                    e.printStackTrace();
                    WrapperManager.closeSocket();
                }
            }
        }
    }

    private static void handleSocket() {
        byte[] buffer = new byte[256];
        try {
            if (m_debug) {
                m_out.println("handleSocket(" + m_socket + ")");
            }
            DataInputStream is = new DataInputStream(m_socket.getInputStream());
            while (!m_disposed) {
                block31: {
                    try {
                        byte b;
                        byte code = is.readByte();
                        int i = 0;
                        do {
                            if ((b = is.readByte()) == 0 || i >= 256) continue;
                            buffer[i] = b;
                            ++i;
                        } while (b != 0);
                        String msg = new String(buffer, 0, i);
                        if (m_appearHung) break block31;
                        if (m_debug) {
                            m_out.println("Received a packet " + WrapperManager.getPacketCodeName(code) + " : " + msg);
                        }
                        switch (code) {
                            case 100: {
                                WrapperManager.startInner();
                                break;
                            }
                            case 101: {
                                if (!m_stopping) {
                                    WrapperManager.stopInner(0);
                                }
                                break;
                            }
                            case 103: {
                                m_lastPingTicks = WrapperManager.getTicks();
                                WrapperManager.sendCommand((byte)103, "ok");
                                break;
                            }
                            case 111: {
                                m_out.println("Authorization key rejected by Wrapper.  Exiting JVM.");
                                WrapperManager.closeSocket();
                                WrapperManager.stopInner(1);
                                break;
                            }
                            case 112: {
                                try {
                                    m_lowLogLevel = Integer.parseInt(msg);
                                    if (m_debug) {
                                        m_out.println("Wrapper Manager: LowLogLevel from Wrapper is " + m_lowLogLevel);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    m_out.println("Encountered an Illegal LowLogLevel from the Wrapper: " + msg);
                                }
                                break;
                            }
                            case 113: {
                                try {
                                    m_pingTimeout = Integer.parseInt(msg) * 1000;
                                    if (m_debug) {
                                        m_out.println("Wrapper Manager: PingTimeout from Wrapper is " + m_pingTimeout);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    m_out.println("Encountered an Illegal PingTimeout from the Wrapper: " + msg);
                                }
                                if (m_pingTimeout <= 0) {
                                    m_socket.setSoTimeout(0);
                                    break;
                                }
                                if (m_soTimeout < m_pingTimeout) {
                                    m_socket.setSoTimeout(m_pingTimeout);
                                }
                                break;
                            }
                            default: {
                                m_out.println("Wrapper code received an unknown packet type: " + code);
                            }
                        }
                    }
                    catch (InterruptedIOException e) {
                        int nowTicks = WrapperManager.getTicks();
                        if (!m_started || m_stopping) break block31;
                        if (m_debug) {
                            m_out.println("Read Timed out. (Last Ping was " + WrapperManager.getTickAge(m_lastPingTicks, nowTicks) + " milliseconds ago)");
                        }
                        if (m_appearHung) break block31;
                        long lastPingAge = WrapperManager.getTickAge(m_lastPingTicks, nowTicks);
                        long eventRunnerAge = WrapperManager.getTickAge(m_eventRunnerTicks, nowTicks);
                        if (eventRunnerAge >= 10000L || m_pingTimeout <= 0) break block31;
                        if (lastPingAge > (long)(m_pingTimeout + 90000)) {
                            m_out.println("Wrapper Manager: JVM did not exit.  Give up.");
                            System.exit(1);
                        }
                        if (lastPingAge <= (long)m_pingTimeout) break block31;
                        m_out.println("Wrapper Manager: The Wrapper code did not ping the JVM for " + lastPingAge / 1000L + " seconds.  " + "Quit and let the Wrapper resynch.");
                        if (m_stopping) break block31;
                        WrapperManager.sendCommand((byte)102, "restart");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                        WrapperManager.stopInner(1);
                    }
                }
                if (!m_started) continue;
                WrapperManager.checkThreads();
            }
            return;
        }
        catch (SocketException e) {
            if (m_debug && m_socket != null) {
                m_out.println("Closed socket: " + e);
            }
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    protected static int getNonDaemonThreadCount() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        while (topGroup.getParent() != null) {
            topGroup = topGroup.getParent();
        }
        Thread[] threads = new Thread[topGroup.activeCount() * 2];
        topGroup.enumerate(threads, true);
        int liveCount = 0;
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threads[i].isAlive() || threads[i].isDaemon() || Thread.currentThread() == threads[i] || threads[i] == m_commRunner) continue;
            ++liveCount;
        }
        return liveCount;
    }

    private static void checkThreads() {
        int liveCount = WrapperManager.getNonDaemonThreadCount();
        if (liveCount <= m_systemThreadCount) {
            if (m_debug) {
                m_out.println("All non-daemon threads have stopped.  Exiting.");
            }
            WrapperManager.stop(0);
        }
    }

    private static void startRunner() {
        if (WrapperManager.isControlledByNativeWrapper() && m_commRunner == null) {
            m_commRunner = new Thread((Runnable)m_instance, WRAPPER_CONNECTION_THREAD_NAME);
            m_commRunner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Thread.currentThread() != m_commRunner) {
            throw new IllegalStateException("Only the comm runner thread is allowed to call this method.");
        }
        m_commRunnerStarted = true;
        Thread.currentThread().setPriority(10);
        m_lastPingTicks = WrapperManager.getTicks();
        boolean gotPortOnce = false;
        while (!m_disposed) {
            try {
                try {
                    WrapperManager.openSocket();
                    if (m_socket != null) {
                        WrapperManager.handleSocket();
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                finally {
                    WrapperManager.closeSocket();
                }
            }
            catch (ThreadDeath td) {
                m_out.println(m_warning.format("SERVER_DAEMON_KILLED"));
            }
            catch (Throwable t) {
                if (m_shuttingDown) continue;
                m_out.println(m_error.format("SERVER_DAEMON_DIED"));
                t.printStackTrace();
            }
        }
        if (m_debug) {
            m_out.println(m_info.format("SERVER_DAEMON_SHUT_DOWN"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_disposed = false;
        m_started = false;
        m_instance = null;
        m_hook = null;
        m_hookTriggered = false;
        m_shutdownJVMComplete = false;
        m_port = 15003;
        m_soTimeout = 10000;
        m_cpuTimeout = 10000L;
        m_lowLogLevel = 8;
        m_pingTimeout = 30000;
        m_ignoreSignals = false;
        m_commRunnerStarted = false;
        m_shuttingDown = false;
        m_appearHung = false;
        m_addShutdownHookMethod = null;
        m_removeShutdownHookMethod = null;
        m_service = false;
        m_debug = false;
        m_jvmId = 0;
        m_stopping = false;
        m_libraryOK = false;
        m_commandBuffer = new byte[512];
        m_error = m_res = ResourceManager.getResourceManager();
        m_warning = m_res;
        m_info = m_res;
        m_out = System.out;
        m_err = System.err;
        m_debug = WrapperManager.getBooleanProperty("wrapper.debug");
        if (m_debug) {
            m_out.println("WrapperManager class initialized by thread: " + Thread.currentThread().getName() + "  Using classloader: " + (class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager).getClassLoader());
        }
        m_jvmId = WrapperManager.getIntProperty("wrapper.jvmid", 1);
        if (m_debug) {
            m_out.println("Wrapper Manager: JVM #" + m_jvmId);
        }
        m_ticks = 0x7FFFFF37;
        m_useSystemTime = System.getProperty("wrapper.use_system_time") != null;
        m_timerFastThreshold = WrapperManager.getIntProperty("wrapper.timer_fast_threshold", 1728000) * 1000 / 100;
        m_timerSlowThreshold = WrapperManager.getIntProperty("wrapper.timer_slow_threshold", 1728000) * 1000 / 100;
        boolean disableShutdownHook = System.getProperty("wrapper.disable_shutdown_hook") != null;
        try {
            m_addShutdownHookMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = WrapperManager.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = WrapperManager.class$("java.lang.Thread")) : class$java$lang$Thread);
            m_removeShutdownHookMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = WrapperManager.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("removeShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = WrapperManager.class$("java.lang.Thread")) : class$java$lang$Thread);
        }
        catch (NoSuchMethodException e) {
            if (m_debug) {
                m_out.println("Wrapper Manager: Shutdown hooks not supported by current JVM.");
            }
            m_addShutdownHookMethod = null;
            m_removeShutdownHookMethod = null;
            disableShutdownHook = true;
        }
        if (!disableShutdownHook) {
            if (m_debug) {
                m_out.println("Wrapper Manager: Registering shutdown hook");
            }
            m_hook = new Thread("Wrapper-Shutdown-Hook"){

                public void run() {
                    m_hookTriggered = true;
                    if (m_debug) {
                        m_out.println("Wrapper Manager: ShutdownHook started");
                    }
                    WrapperManager.stop(0);
                    if (m_debug) {
                        m_out.println("Wrapper Manager: ShutdownHook complete");
                    }
                }
            };
            try {
                m_addShutdownHookMethod.invoke((Object)Runtime.getRuntime(), m_hook);
            }
            catch (IllegalAccessException e) {
                m_out.println("Wrapper Manager: Unable to register shutdown hook: " + e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t == null) {
                    t = e;
                }
                m_out.println("Wrapper Manager: Unable to register shutdown hook: " + t);
            }
        }
        if ((m_key = System.getProperty("wrapper.key")) == null) {
            if (m_debug) {
                m_out.println("Wrapper Manager: Not using wrapper.  (key not specified)");
            }
            m_port = 0;
            m_service = false;
            m_cpuTimeout = 31557600000L;
        } else {
            if (m_debug) {
                m_out.println("Wrapper Manager: Using wrapper");
            }
            System.setIn(new WrapperInputStream());
            String sPort = System.getProperty("wrapper.port");
            if (sPort == null) {
                String msg = m_res.format("MISSING_PORT");
                m_out.println(msg);
                throw new ExceptionInInitializerError(msg);
            }
            try {
                m_port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException e) {
                String msg = m_res.format("BAD_PORT", sPort);
                m_out.println(msg);
                throw new ExceptionInInitializerError(msg);
            }
            m_ignoreSignals = WrapperManager.getBooleanProperty("wrapper.ignore_signals");
            m_service = WrapperManager.getBooleanProperty("wrapper.service");
            String sCPUTimeout = System.getProperty("wrapper.cpu.timeout");
            if (sCPUTimeout == null) {
                m_cpuTimeout = 10000L;
            } else {
                try {
                    m_cpuTimeout = (long)Integer.parseInt(sCPUTimeout) * 1000L;
                }
                catch (NumberFormatException e) {
                    String msg = m_res.format("BAD_CPU_TIMEOUT", sCPUTimeout);
                    m_out.println(msg);
                    throw new ExceptionInInitializerError(msg);
                }
            }
        }
        WrapperManager.verifyWrapperVersion();
        WrapperManager.initializeNativeLibrary();
        WrapperManager.verifyNativeLibraryVersion();
        m_eventRunnerTicks = WrapperManager.getTicks();
        m_eventRunner = new Thread("Wrapper-Control-Event-Monitor"){

            public void run() {
                int lastTickOffset = 0;
                boolean first = true;
                while (!m_shuttingDown) {
                    int event;
                    if (!m_useSystemTime) {
                        int sysTicks = WrapperManager.getSystemTicks();
                        m_ticks++;
                        int tickOffset = sysTicks - m_ticks;
                        int offsetDiff = tickOffset - lastTickOffset;
                        if (first) {
                            first = false;
                        } else if (offsetDiff > m_timerSlowThreshold) {
                            m_out.println("The timer fell behind the system clock by " + offsetDiff * 100 + "ms.");
                        } else if (offsetDiff < -m_timerFastThreshold) {
                            m_out.println("The system clock fell behind the timer by " + -1 * offsetDiff * 100 + "ms.");
                        }
                        lastTickOffset = tickOffset;
                    }
                    int nowTicks = WrapperManager.getTicks();
                    long age = WrapperManager.getTickAge(m_eventRunnerTicks, nowTicks);
                    if (age > m_cpuTimeout) {
                        m_out.println("JVM Process has not received any CPU time for " + age / 1000L + " seconds.  Extending timeouts.");
                        m_lastPingTicks = nowTicks;
                    }
                    m_eventRunnerTicks = nowTicks;
                    if (m_libraryOK && (event = WrapperManager.nativeGetControlEvent()) != 0) {
                        WrapperManager.controlEvent(event);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        };
        m_eventRunner.setDaemon(true);
        m_eventRunner.start();
        String fullVersion = System.getProperty("java.fullversion");
        if (fullVersion == null) {
            fullVersion = System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name");
        }
        m_systemThreadCount = fullVersion.indexOf("JRockit") >= 0 ? 0 : 1;
        if (m_debug) {
            m_out.println("Java Version   : " + fullVersion);
            m_out.println("Java VM Vendor : " + System.getProperty("java.vm.vendor"));
            m_out.println();
        }
        m_instance = new WrapperManager();
    }

    private static class WrapperInputStream
    extends InputStream {
        private WrapperInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            m_out.println("WARNING - System.in can not be used when the JVM is being controlled by the Java Service Wrapper.  Calls will block indefinitely.");
            while (true) {
                WrapperInputStream wrapperInputStream = this;
                synchronized (wrapperInputStream) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

