/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.RouterContext;

public class TunnelVerificationStructure
extends DataStructureImpl {
    private Hash _msgHash;
    private Signature _authSignature;

    public TunnelVerificationStructure() {
        this(null, null);
    }

    public TunnelVerificationStructure(Hash messageHash, Signature authSig) {
        this.setMessageHash(messageHash);
        this.setAuthorizationSignature(authSig);
    }

    public Hash getMessageHash() {
        return this._msgHash;
    }

    public void setMessageHash(Hash hash) {
        this._msgHash = hash;
    }

    public Signature getAuthorizationSignature() {
        return this._authSignature;
    }

    public void setAuthorizationSignature(Signature sig) {
        this._authSignature = sig;
    }

    public void sign(RouterContext context, SigningPrivateKey key) {
        if (this._msgHash != null) {
            Signature sig = context.dsa().sign(this._msgHash.getData(), key);
            this.setAuthorizationSignature(sig);
        }
    }

    public boolean verifySignature(RouterContext context, SigningPublicKey key) {
        if (this._msgHash == null) {
            return false;
        }
        return context.dsa().verifySignature(this._authSignature, this._msgHash.getData(), key);
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._msgHash = new Hash();
        this._msgHash.readBytes(in);
        this._authSignature = new Signature();
        this._authSignature.readBytes(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._authSignature == null) {
            this._authSignature = new Signature();
            this._authSignature.setData(Signature.FAKE_SIGNATURE);
        }
        if (this._msgHash == null || this._authSignature == null) {
            throw new DataFormatException("Invalid data");
        }
        this._msgHash.writeBytes(out);
        this._authSignature.writeBytes(out);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TunnelVerificationStructure)) {
            return false;
        }
        TunnelVerificationStructure str = (TunnelVerificationStructure)((Object)obj);
        return DataHelper.eq((Object)this.getMessageHash(), (Object)str.getMessageHash()) && DataHelper.eq((Object)this.getAuthorizationSignature(), (Object)str.getAuthorizationSignature());
    }

    public int hashCode() {
        if (this._msgHash == null || this._authSignature == null) {
            return 0;
        }
        return this.getMessageHash().hashCode() + this.getAuthorizationSignature().hashCode();
    }

    public String toString() {
        return "[TunnelVerificationStructure: " + this.getMessageHash() + " " + this.getAuthorizationSignature() + "]";
    }
}

