/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;

public class Blocklist {
    private Log _log;
    private RouterContext _context;
    private long[] _blocklist;
    private int _blocklistSize;
    private Object _lock;
    private Entry _wrapSave;
    private Set _inProcess;
    private Map _peerBlocklist;
    private Set _singleIPBlocklist;
    static final String PROP_BLOCKLIST_ENABLED = "router.blocklist.enable";
    static final String PROP_BLOCKLIST_DETAIL = "router.blocklist.detail";
    static final String PROP_BLOCKLIST_FILE = "router.blocklist.file";
    static final String BLOCKLIST_FILE_DEFAULT = "blocklist.txt";

    public Blocklist(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(Blocklist.class);
        this._blocklist = null;
        this._blocklistSize = 0;
        this._lock = new Object();
        this._wrapSave = null;
        this._inProcess = new HashSet(0);
        this._peerBlocklist = new HashMap(0);
        this._singleIPBlocklist = new HashSet(0);
    }

    public Blocklist() {
        this._log = new Log(Blocklist.class);
        this._blocklist = null;
        this._blocklistSize = 0;
    }

    public void startup() {
        String enabled = this._context.getProperty(PROP_BLOCKLIST_ENABLED, "false");
        if (!"true".equals(enabled)) {
            return;
        }
        String file = this._context.getProperty(PROP_BLOCKLIST_FILE, BLOCKLIST_FILE_DEFAULT);
        ReadinJob job = new ReadinJob(file);
        job.getTiming().setStartAfter(this._context.clock().now() + 120000L);
        this._context.jobQueue().addJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this._lock;
        synchronized (object) {
            this._blocklistSize = 0;
            this._blocklist = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBlocklistFile(String file) {
        File BLFile = new File(file);
        if (BLFile == null || !BLFile.exists() || BLFile.length() <= 0L) {
            if (this._log.shouldLog(40)) {
                this._log.error("Blocklist file not found: " + file);
            }
            return;
        }
        long start = this._context.clock().now();
        int maxSize = this.getSize(BLFile);
        try {
            this._blocklist = new long[maxSize + 1];
        }
        catch (OutOfMemoryError oom) {
            this._log.log(50, "OOM creating the blocklist");
            return;
        }
        int count = 0;
        int badcount = 0;
        int peercount = 0;
        long ipcount = 0L;
        FileInputStream in = null;
        try {
            in = new FileInputStream(BLFile);
            StringBuffer buf = new StringBuffer(128);
            while (DataHelper.readLine((InputStream)in, (StringBuffer)buf) && count < maxSize) {
                Entry e = this.parse(buf, true);
                buf.setLength(0);
                if (e == null) {
                    ++badcount;
                    continue;
                }
                if (e.peer != null) {
                    this._peerBlocklist.put(e.peer, e.comment);
                    ++peercount;
                    continue;
                }
                byte[] ip1 = e.ip1;
                byte[] ip2 = e.ip2;
                this.store(ip1, ip2, count++);
                ipcount += (long)(1 + this.toInt(ip2) - this.toInt(ip1));
            }
        }
        catch (IOException ioe) {
            this._blocklist = null;
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the BLFile", (Throwable)ioe);
            }
            return;
        }
        catch (OutOfMemoryError oom) {
            this._blocklist = null;
            this._log.log(50, "OOM reading the blocklist");
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this._wrapSave != null) {
            this.store(this._wrapSave.ip1, this._wrapSave.ip2, count++);
            ipcount += (long)(1 + this.toInt(this._wrapSave.ip2) - this.toInt(this._wrapSave.ip1));
        }
        int removed = 0;
        try {
            Arrays.sort(this._blocklist, 0, count);
            removed = this.removeOverlap(this._blocklist, count);
            if (removed > 0) {
                Arrays.sort(this._blocklist, 0, count);
            }
        }
        catch (OutOfMemoryError oom) {
            this._blocklist = null;
            this._log.log(50, "OOM sorting the blocklist");
            return;
        }
        this._blocklistSize = count - removed;
        if (this._log.shouldLog(30)) {
            this._log.warn("Removed " + badcount + " bad entries and comment lines");
            this._log.warn("Read " + count + " valid entries from the blocklist " + BLFile);
            this._log.warn("Merged " + removed + " overlapping entries");
            this._log.warn("Result is " + this._blocklistSize + " entries");
            this._log.warn("Blocking " + ipcount + " IPs and " + peercount + " hashes");
            this._log.warn("Blocklist processing finished, time: " + (this._context.clock().now() - start));
        }
    }

    private Entry parse(StringBuffer buf, boolean bitch) {
        byte[] ip2;
        byte[] ip1;
        byte[] b;
        int start1 = 0;
        int end1 = buf.length();
        if (end1 <= 0) {
            return null;
        }
        if (buf.charAt(end1 - 1) == '\r') {
            buf.deleteCharAt(end1 - 1);
            --end1;
        }
        if (end1 <= 0) {
            return null;
        }
        int start2 = -1;
        int mask = -1;
        String comment = null;
        int index = buf.indexOf("#");
        if (index == 0) {
            return null;
        }
        index = buf.lastIndexOf(":");
        if (index >= 0) {
            comment = buf.substring(0, index);
            start1 = index + 1;
        }
        if (end1 - start1 == 44 && buf.substring(start1).indexOf(".") < 0 && (b = Base64.decode((String)buf.substring(start1))) != null) {
            return new Entry(comment, new Hash(b), null, null);
        }
        index = buf.indexOf("-", start1);
        if (index >= 0) {
            end1 = index;
            start2 = index + 1;
        } else {
            index = buf.indexOf("/", start1);
            if (index >= 0) {
                end1 = index;
                mask = index + 1;
            }
        }
        if (end1 - start1 <= 0) {
            return null;
        }
        try {
            InetAddress pi = InetAddress.getByName(buf.substring(start1, end1));
            if (pi == null) {
                return null;
            }
            ip1 = pi.getAddress();
            if (ip1.length != 4) {
                throw new UnknownHostException();
            }
            if (start2 >= 0) {
                pi = InetAddress.getByName(buf.substring(start2));
                if (pi == null) {
                    return null;
                }
                ip2 = pi.getAddress();
                if (ip2.length != 4) {
                    throw new UnknownHostException();
                }
                if ((ip1[0] & 0xFF) < 128 && (ip2[0] & 0xFF) >= 128) {
                    if (this._wrapSave == null) {
                        this._wrapSave = new Entry(comment, null, new byte[]{-128, 0, 0, 0}, new byte[]{ip2[0], ip2[1], ip2[2], ip2[3]});
                        ip2 = new byte[]{127, -1, -1, -1};
                    } else {
                        throw new NumberFormatException();
                    }
                }
                for (int i = 0; i < 4 && (ip2[i] & 0xFF) <= (ip1[i] & 0xFF); ++i) {
                    if ((ip2[i] & 0xFF) >= (ip1[i] & 0xFF)) continue;
                    throw new NumberFormatException();
                }
            } else if (mask >= 0) {
                int i;
                int m = Integer.parseInt(buf.substring(mask));
                if (m < 3 || m > 32) {
                    throw new NumberFormatException();
                }
                ip2 = new byte[4];
                for (i = 0; i < 4; ++i) {
                    ip2[i] = ip1[i];
                }
                for (i = 0; i < 32 - m; ++i) {
                    int n = (31 - i) / 8;
                    ip2[n] = (byte)(ip2[n] | 1 << i % 8);
                }
            } else {
                ip2 = ip1;
            }
        }
        catch (UnknownHostException uhe) {
            if (bitch && this._log.shouldLog(40)) {
                this._log.error("Format error in the blocklist file: " + buf);
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            if (bitch && this._log.shouldLog(40)) {
                this._log.error("Format error in the blocklist file: " + buf);
            }
            return null;
        }
        catch (IndexOutOfBoundsException ioobe) {
            if (bitch && this._log.shouldLog(40)) {
                this._log.error("Format error in the blocklist file: " + buf);
            }
            return null;
        }
        return new Entry(comment, null, ip1, ip2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize(File BLFile) {
        if (!BLFile.exists() || BLFile.length() <= 0L) {
            return 0;
        }
        int lines = 0;
        FileInputStream in = null;
        try {
            in = new FileInputStream(BLFile);
            StringBuffer buf = new StringBuffer(128);
            while (DataHelper.readLine((InputStream)in, (StringBuffer)buf)) {
                ++lines;
                buf.setLength(0);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error reading the BLFile", (Throwable)ioe);
            }
            int n = 0;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return lines;
    }

    private int removeOverlap(long[] blist, int count) {
        int removed;
        if (count <= 0) {
            return 0;
        }
        int lines = 0;
        for (int i = 0; i < count - 1; i += removed + 1) {
            removed = 0;
            int to = this.getTo(blist[i]);
            for (int next = i + 1; next < count && to >= this.getFrom(blist[next]); ++next) {
                int nextTo;
                if (this._log.shouldLog(30)) {
                    this._log.warn("Combining entries " + this.toStr(blist[i]) + " and " + this.toStr(blist[next]));
                }
                if ((nextTo = this.getTo(blist[next])) > to) {
                    this.store(this.getFrom(blist[i]), nextTo, i);
                }
                blist[next] = Long.MAX_VALUE;
                ++lines;
                ++removed;
            }
        }
        return lines;
    }

    public void add(String ip) {
        InetAddress pi;
        try {
            pi = InetAddress.getByName(ip);
        }
        catch (UnknownHostException uhe) {
            return;
        }
        if (pi == null) {
            return;
        }
        byte[] pib = pi.getAddress();
        this.add(pib);
    }

    public void add(byte[] ip) {
        if (ip.length != 4) {
            return;
        }
        if (this.add(this.toInt(ip)) && this._log.shouldLog(30)) {
            this._log.warn("Adding IP to blocklist: " + (ip[0] & 0xFF) + '.' + (ip[1] & 0xFF) + '.' + (ip[2] & 0xFF) + '.' + (ip[3] & 0xFF));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(int ip) {
        Set set = this._singleIPBlocklist;
        synchronized (set) {
            return this._singleIPBlocklist.add(new Integer(ip));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOnSingleList(int ip) {
        Set set = this._singleIPBlocklist;
        synchronized (set) {
            return this._singleIPBlocklist.contains(new Integer(ip));
        }
    }

    public List getAddresses(Hash peer) {
        ArrayList<byte[]> rv = new ArrayList<byte[]>(1);
        RouterInfo pinfo = this._context.netDb().lookupRouterInfoLocally(peer);
        if (pinfo == null) {
            return rv;
        }
        Set paddr = pinfo.getAddresses();
        if (paddr == null || paddr.size() == 0) {
            return rv;
        }
        String oldphost = null;
        ArrayList pladdr = new ArrayList(paddr);
        for (int j = 0; j < paddr.size(); ++j) {
            InetAddress pi;
            String phost;
            Properties pprops;
            RouterAddress pa = (RouterAddress)pladdr.get(j);
            if (pa == null || (pprops = pa.getOptions()) == null || (phost = pprops.getProperty("host")) == null || oldphost != null && oldphost.equals(phost)) continue;
            oldphost = phost;
            try {
                pi = InetAddress.getByName(phost);
            }
            catch (UnknownHostException uhe) {
                continue;
            }
            if (pi == null) continue;
            byte[] pib = pi.getAddress();
            rv.add(pib);
        }
        return rv;
    }

    public boolean isBlocklisted(Hash peer) {
        List ips = this.getAddresses(peer);
        for (byte[] ip : ips) {
            if (!this.isBlocklisted(ip)) continue;
            if (!this._context.shitlist().isShitlisted(peer)) {
                this.shitlist(peer);
            }
            return true;
        }
        return false;
    }

    public boolean isBlocklisted(String ip) {
        InetAddress pi;
        try {
            pi = InetAddress.getByName(ip);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        if (pi == null) {
            return false;
        }
        byte[] pib = pi.getAddress();
        return this.isBlocklisted(pib);
    }

    public boolean isBlocklisted(byte[] ip) {
        if (ip.length != 4) {
            return false;
        }
        return this.isBlocklisted(this.toInt(ip));
    }

    private boolean isBlocklisted(int ip) {
        if (this.isOnSingleList(ip)) {
            return true;
        }
        int hi = this._blocklistSize - 1;
        if (hi <= 0) {
            return false;
        }
        int lo = 0;
        int cur = hi / 2;
        while (!this.match(ip, cur)) {
            if (this.isHigher(ip, cur)) {
                lo = cur;
            } else {
                hi = cur;
            }
            if (hi - lo <= 1) {
                if (lo == cur) {
                    cur = hi;
                    break;
                }
                cur = lo;
                break;
            }
            cur = lo + (hi - lo) / 2;
        }
        return this.match(ip, cur);
    }

    private boolean match(int ip, int cur) {
        return this.match(ip, this._blocklist[cur]);
    }

    private boolean match(int ip, long entry) {
        if (this.getFrom(entry) > ip) {
            return false;
        }
        return ip <= this.getTo(entry);
    }

    private boolean isHigher(int ip, int cur) {
        return ip > this.getFrom(this._blocklist[cur]);
    }

    private int getFrom(long entry) {
        return (int)(entry >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    private int getTo(long entry) {
        return (int)(entry & 0xFFFFFFFFFFFFFFFFL);
    }

    private long toEntry(byte[] ip1, byte[] ip2) {
        int i;
        long entry = 0L;
        for (i = 0; i < 4; ++i) {
            entry |= (long)(ip2[i] & 0xFF) << (3 - i) * 8;
        }
        for (i = 0; i < 4; ++i) {
            entry |= (long)(ip1[i] & 0xFF) << 32 + (3 - i) * 8;
        }
        return entry;
    }

    private void store(byte[] ip1, byte[] ip2, int idx) {
        this._blocklist[idx] = this.toEntry(ip1, ip2);
    }

    private void store(int ip1, int ip2, int idx) {
        long entry = (long)ip1 << 32;
        this._blocklist[idx] = entry |= (long)ip2;
    }

    private int toInt(byte[] ip) {
        int rv = 0;
        for (int i = 0; i < 4; ++i) {
            rv |= (ip[i] & 0xFF) << (3 - i) * 8;
        }
        return rv;
    }

    private String toStr(long entry) {
        StringBuffer buf = new StringBuffer(32);
        for (int i = 7; i >= 0; --i) {
            buf.append(entry >> 8 * i & 0xFFL);
            if (i == 4) {
                buf.append('-');
                continue;
            }
            if (i <= 0) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    private String toStr(int ip) {
        StringBuffer buf = new StringBuffer(16);
        for (int i = 3; i >= 0; --i) {
            buf.append(ip >> 8 * i & 0xFF);
            if (i <= 0) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shitlist(Hash peer) {
        boolean shouldRunJob;
        int number;
        this._context.shitlist().shitlistRouterForever(peer, "IP Blocklisted");
        if (!"true".equals(this._context.getProperty(PROP_BLOCKLIST_DETAIL, "true"))) {
            return;
        }
        Set set = this._inProcess;
        synchronized (set) {
            number = this._inProcess.size();
            shouldRunJob = this._inProcess.add(peer);
        }
        if (!shouldRunJob) {
            return;
        }
        ShitlistJob job = new ShitlistJob(peer);
        if (number > 0) {
            job.getTiming().setStartAfter(this._context.clock().now() + (long)(number * 30 * 1000));
        }
        this._context.jobQueue().addJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shitlistForever(Hash peer) {
        String file = this._context.getProperty(PROP_BLOCKLIST_FILE, BLOCKLIST_FILE_DEFAULT);
        File BLFile = new File(file);
        if (BLFile == null || !BLFile.exists() || BLFile.length() <= 0L) {
            if (this._log.shouldLog(40)) {
                this._log.error("Blocklist file not found: " + file);
            }
            return;
        }
        List ips = this.getAddresses(peer);
        for (byte[] ip : ips) {
            int ipint = this.toInt(ip);
            FileInputStream in = null;
            try {
                in = new FileInputStream(BLFile);
                StringBuffer buf = new StringBuffer(128);
                while (DataHelper.readLine((InputStream)in, (StringBuffer)buf)) {
                    Entry e = this.parse(buf, false);
                    if (e == null || e.peer != null) {
                        buf.setLength(0);
                        continue;
                    }
                    if (this.match(ipint, this.toEntry(e.ip1, e.ip2))) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        String reason = "IP ";
                        for (int i = 0; i < 4; ++i) {
                            reason = reason + (ip[i] & 0xFF);
                            if (i == 3) continue;
                            reason = reason + '.';
                        }
                        reason = reason + " blocklisted by entry \"" + buf + "\"";
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Shitlisting " + peer + " " + reason);
                        }
                        this._context.shitlist().shitlistRouterForever(peer, reason);
                        return;
                    }
                    buf.setLength(0);
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Error reading the BLFile", (Throwable)ioe);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStatusHTML(Writer out) throws IOException {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("<h2>IP Blocklist</h2>");
        TreeSet singles = new TreeSet();
        Set set = this._singleIPBlocklist;
        synchronized (set) {
            singles.addAll(this._singleIPBlocklist);
        }
        if (singles.size() > 0) {
            buf.append("<table><tr><td><b>Transient IPs</b></td></tr>");
            Iterator iter = singles.iterator();
            while (iter.hasNext()) {
                int ip = (Integer)iter.next();
                buf.append("<tr><td align=right>").append(this.toStr(ip)).append("</td></tr>\n");
            }
            buf.append("</table>");
        }
        if (this._blocklistSize > 0) {
            buf.append("<table><tr><td align=center colspan=2><b>IPs from Blocklist File</b></td></tr><tr><td align=center><b>From</b></td><td align=center><b>To</b></td></tr>");
            for (int i = 0; i < this._blocklistSize; ++i) {
                int from = this.getFrom(this._blocklist[i]);
                buf.append("<tr><td align=right>").append(this.toStr(from)).append("</td><td align=right>");
                int to = this.getTo(this._blocklist[i]);
                if (to != from) {
                    buf.append(this.toStr(to)).append("</td></tr>\n");
                    continue;
                }
                buf.append("&nbsp</td></tr>\n");
            }
            buf.append("</table>");
        } else {
            buf.append("<br>No blocklist file entries");
        }
        out.write(buf.toString());
        out.flush();
    }

    public static void main(String[] args) {
        Blocklist b = new Blocklist();
        if (args != null && args.length == 1) {
            b.readBlocklistFile(args[0]);
        }
        System.out.println("Saved " + b._blocklistSize + " records");
        String[] tests = new String[]{"0.0.0.0", "0.0.0.1", "0.0.0.2", "0.0.0.255", "1.0.0.0", "3.3.3.3", "77.1.2.3", "127.0.0.0", "127.127.127.127", "128.0.0.0", "129.1.2.3", "255.255.255.254", "255.255.255.255"};
        for (int i = 0; i < tests.length; ++i) {
            System.out.println("Testing " + tests[i] + " returns " + b.isBlocklisted(tests[i]));
        }
    }

    private class ShitlistJob
    extends JobImpl {
        private Hash _peer;

        public ShitlistJob(Hash p) {
            super(Blocklist.this._context);
            this._peer = p;
        }

        public String getName() {
            return "Shitlist Peer Forever";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJob() {
            Blocklist.this.shitlistForever(this._peer);
            Set set = Blocklist.this._inProcess;
            synchronized (set) {
                Blocklist.this._inProcess.remove(this._peer);
            }
        }
    }

    private class Entry {
        String comment;
        byte[] ip1;
        byte[] ip2;
        Hash peer;

        public Entry(String c, Hash h, byte[] i1, byte[] i2) {
            this.comment = c;
            this.peer = h;
            this.ip1 = i1;
            this.ip2 = i2;
        }
    }

    private class ReadinJob
    extends JobImpl {
        private String _file;

        public ReadinJob(String f) {
            super(Blocklist.this._context);
            this._file = f;
        }

        public String getName() {
            return "Read Blocklist";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJob() {
            Object object = Blocklist.this._lock;
            synchronized (object) {
                try {
                    Blocklist.this.readBlocklistFile(this._file);
                }
                catch (OutOfMemoryError oom) {
                    Blocklist.this._log.log(50, "OOM processing the blocklist");
                    Blocklist.this.disable();
                    return;
                }
            }
            for (Hash peer : Blocklist.this._peerBlocklist.keySet()) {
                String reason = "Blocklisted by router hash";
                String comment = (String)Blocklist.this._peerBlocklist.get(peer);
                if (comment != null) {
                    reason = reason + ": " + comment;
                }
                Blocklist.this._context.shitlist().shitlistRouterForever(peer, reason);
            }
            Blocklist.this._peerBlocklist = null;
            if (Blocklist.this._blocklistSize <= 0) {
                return;
            }
            FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)Blocklist.this._context.netDb();
            int count = 0;
            for (RouterInfo ri : fndf.getKnownRouterData()) {
                Hash peer = ri.getIdentity().getHash();
                if (!Blocklist.this.isBlocklisted(peer)) continue;
                ++count;
            }
            if (count > 0 && Blocklist.this._log.shouldLog(30)) {
                Blocklist.this._log.warn("Blocklisted " + count + " routers in the netDb.");
            }
        }
    }
}

