/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.RouterContext;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.SimpleTimer;

class CoalesceStatsEvent
implements SimpleTimer.TimedEvent {
    private RouterContext _ctx;

    public CoalesceStatsEvent(RouterContext ctx) {
        this._ctx = ctx;
        ctx.statManager().createRateStat("bw.receiveBps", "How fast we receive data (in KBps)", "Bandwidth", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRateStat("bw.sendBps", "How fast we send data (in KBps)", "Bandwidth", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRateStat("bw.sendRate", "Low level bandwidth send rate", "Bandwidth", new long[]{60000L, 300000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("bw.recvRate", "Low level bandwidth receive rate", "Bandwidth", new long[]{60000L, 300000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("router.activePeers", "How many peers we are actively talking with", "Throttle", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRateStat("router.activeSendPeers", "How many peers we've sent to this minute", "Throttle", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRateStat("router.highCapacityPeers", "How many high capacity peers we know", "Throttle", new long[]{300000L, 3600000L});
        ctx.statManager().createRateStat("router.fastPeers", "How many fast peers we know", "Throttle", new long[]{300000L, 3600000L});
    }

    private RouterContext getContext() {
        return this._ctx;
    }

    public void timeReached() {
        Rate rate;
        RateStat sendRate;
        Rate rate2;
        int active = this.getContext().commSystem().countActivePeers();
        this.getContext().statManager().addRateData("router.activePeers", (long)active, 60000L);
        int activeSend = this.getContext().commSystem().countActiveSendPeers();
        this.getContext().statManager().addRateData("router.activeSendPeers", (long)activeSend, 60000L);
        int fast = this.getContext().profileOrganizer().countFastPeers();
        this.getContext().statManager().addRateData("router.fastPeers", (long)fast, 60000L);
        int highCap = this.getContext().profileOrganizer().countHighCapacityPeers();
        this.getContext().statManager().addRateData("router.highCapacityPeers", (long)highCap, 60000L);
        this.getContext().statManager().addRateData("bw.sendRate", (long)this.getContext().bandwidthLimiter().getSendBps(), 0L);
        this.getContext().statManager().addRateData("bw.recvRate", (long)this.getContext().bandwidthLimiter().getReceiveBps(), 0L);
        this.getContext().tunnelDispatcher().updateParticipatingStats();
        this.getContext().statManager().coalesceStats();
        RateStat receiveRate = this.getContext().statManager().getRate("transport.receiveMessageSize");
        if (receiveRate != null && (rate2 = receiveRate.getRate(60000L)) != null) {
            double bytes = rate2.getLastTotalValue();
            double KBps = bytes * 1000.0 / ((double)rate2.getPeriod() * 1024.0);
            this.getContext().statManager().addRateData("bw.receiveBps", (long)KBps, 60000L);
        }
        if ((sendRate = this.getContext().statManager().getRate("transport.sendMessageSize")) != null && (rate = sendRate.getRate(60000L)) != null) {
            double bytes = rate.getLastTotalValue();
            double KBps = bytes * 1000.0 / ((double)rate.getPeriod() * 1024.0);
            this.getContext().statManager().addRateData("bw.sendBps", (long)KBps, 60000L);
        }
        SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, 20000L);
    }
}

