/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class MessageStateMonitor {
    private Log _log;
    private RouterContext _context;
    private volatile int _inboundLiveCount;
    private volatile int _inboundReadCount;
    private volatile int _inboundFinalizedCount;
    private volatile int _outboundLiveCount;
    private volatile int _outboundDiscardedCount;

    public MessageStateMonitor(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(MessageStateMonitor.class);
        this._inboundLiveCount = 0;
        this._inboundReadCount = 0;
        this._inboundFinalizedCount = 0;
        this._outboundLiveCount = 0;
        this._outboundDiscardedCount = 0;
    }

    public void inboundMessageAdded() {
        ++this._inboundLiveCount;
        this.logStatus("inboundAdded     ");
    }

    public void inboundMessageRead() {
        ++this._inboundReadCount;
        --this._inboundLiveCount;
        this.logStatus("inboundRead      ");
    }

    public void inboundMessageFinalized() {
        --this._inboundReadCount;
        ++this._inboundFinalizedCount;
        this.logStatus("inboundFinalized ");
    }

    public void outboundMessageAdded() {
        ++this._outboundLiveCount;
        this.logStatus("outboundAdded    ");
    }

    public void outboundMessageDiscarded() {
        ++this._outboundDiscardedCount;
        --this._outboundLiveCount;
        this.logStatus("outboundDiscarded");
    }

    public void outboundMessageFinalized() {
        --this._outboundDiscardedCount;
        this.logStatus("outboundFinalized");
    }

    private void logStatus(String event) {
        if (this._log.shouldLog(10)) {
            this._log.debug(event + ": outbound (live: " + this._outboundLiveCount + " discarded:" + this._outboundDiscardedCount + ")" + " inbound (live: " + this._inboundLiveCount + " read: " + this._inboundReadCount + ")");
        }
    }

    public int getInboundLiveCount() {
        return this._inboundLiveCount;
    }

    public int getInboundReadCount() {
        return this._inboundReadCount;
    }

    public int getOutboundLiveCount() {
        return this._outboundLiveCount;
    }

    public int getOutboundDiscardedCount() {
        return this._outboundDiscardedCount;
    }
}

