/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.Comparator;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class OutNetMessagePool {
    private Log _log;
    private RouterContext _context;

    public OutNetMessagePool(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(OutNetMessagePool.class);
    }

    public OutNetMessage getNext() {
        return null;
    }

    public void add(OutNetMessage msg) {
        MessageSelector selector;
        boolean valid = this.validate(msg);
        if (!valid) {
            this._context.messageRegistry().unregisterPending(msg);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Adding outbound message to " + msg.getTarget().getIdentity().getHash().toBase64().substring(0, 6) + " with id " + msg.getMessage().getUniqueId() + " expiring on " + msg.getMessage().getMessageExpiration() + " of type " + msg.getMessageType());
        }
        if ((selector = msg.getReplySelector()) != null) {
            this._context.messageRegistry().registerPending(msg);
        }
        this._context.commSystem().processMessage(msg);
    }

    private boolean validate(OutNetMessage msg) {
        if (msg == null) {
            return false;
        }
        if (msg.getMessage() == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Null message in the OutNetMessage - expired too soon");
            }
            return false;
        }
        if (msg.getTarget() == null) {
            this._log.error("No target in the OutNetMessage: " + msg, (Throwable)new Exception("Definitely a fuckup"));
            return false;
        }
        if (msg.getPriority() < 0) {
            this._log.warn("Priority less than 0?  sounds like nonsense to me... " + msg, (Throwable)new Exception("Negative priority"));
            return false;
        }
        if (msg.getExpiration() <= this._context.clock().now()) {
            this._log.error("Already expired!  wtf: " + msg, (Throwable)new Exception("Expired message"));
            return false;
        }
        return true;
    }

    public void clearExpired() {
    }

    public int getCount() {
        return 0;
    }

    public int getCount(int priority) {
        return 0;
    }

    public void dumpPoolInfo() {
    }

    private static class ReverseIntegerComparator
    implements Comparator {
        private ReverseIntegerComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            if (lhs == null || rhs == null) {
                return 0;
            }
            if (!(lhs instanceof Integer) || !(rhs instanceof Integer)) {
                return 0;
            }
            Integer lv = (Integer)lhs;
            Integer rv = (Integer)rhs;
            return -lv.compareTo(rv);
        }
    }
}

