/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

class PersistRouterInfoJob
extends JobImpl {
    private Log _log;

    public PersistRouterInfoJob(RouterContext ctx) {
        super(ctx);
    }

    public String getName() {
        return "Persist Updated Router Information";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob() {
        String infoFilename;
        this._log = this.getContext().logManager().getLog(PersistRouterInfoJob.class);
        if (this._log.shouldLog(10)) {
            this._log.debug("Persisting updated router info");
        }
        if ((infoFilename = this.getContext().getProperty("router.info.location")) == null) {
            infoFilename = "router.info";
        }
        RouterInfo info = this.getContext().router().getRouterInfo();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(infoFilename);
            info.writeBytes((OutputStream)fos);
        }
        catch (DataFormatException dfe) {
            this._log.error("Error rebuilding the router information", (Throwable)dfe);
        }
        catch (IOException ioe) {
            this._log.error("Error writing out the rebuilt router information", (Throwable)ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

