/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import net.i2p.crypto.PersistentSessionKeyManager;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.Service;
import net.i2p.util.Log;

public class SessionKeyPersistenceHelper
implements Service {
    private Log _log;
    private RouterContext _context;
    private SessionKeyWriterJob _writerJob;
    private static final long PERSIST_DELAY = 180000L;
    private static final String PROP_SESSION_KEY_FILE = "router.sessionKeys.location";
    private static final String DEFAULT_SESSION_KEY_FILE = "sessionKeys.dat";

    public SessionKeyPersistenceHelper(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(SessionKeyPersistenceHelper.class);
        this._writerJob = new SessionKeyWriterJob();
    }

    public void shutdown() {
        this.writeState();
    }

    public void restart() {
        this.writeState();
        this.startup();
    }

    private String getKeyFile() {
        String val = this._context.router().getConfigSetting(PROP_SESSION_KEY_FILE);
        if (val == null) {
            val = DEFAULT_SESSION_KEY_FILE;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        SessionKeyManager mgr = this._context.sessionKeyManager();
        if (mgr instanceof PersistentSessionKeyManager) {
            PersistentSessionKeyManager manager = (PersistentSessionKeyManager)mgr;
            File f = new File(this.getKeyFile());
            if (f.exists()) {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(f);
                    manager.loadState((InputStream)fin);
                    int expired = manager.aggressiveExpire();
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Session keys loaded [not error] with " + expired + " sets immediately expired");
                    }
                }
                catch (Throwable t) {
                    this._log.error("Error reading in session key data", t);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            this._context.jobQueue().addJob(this._writerJob);
        }
    }

    private void writeState() {
    }

    public void renderStatusHTML(Writer out) {
    }

    private class SessionKeyWriterJob
    extends JobImpl {
        public SessionKeyWriterJob() {
            super(SessionKeyPersistenceHelper.this._context);
            this.getTiming().setStartAfter(180000L);
        }

        public String getName() {
            return "Write Session Keys";
        }

        public void runJob() {
            SessionKeyPersistenceHelper.this.writeState();
            this.requeue(180000L);
        }
    }
}

