/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.admin;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.i2p.router.RouterContext;
import net.i2p.router.admin.AdminRunner;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class AdminListener
implements Runnable {
    private Log _log;
    private RouterContext _context;
    private ServerSocket _socket;
    private int _port;
    private boolean _running;
    private long _nextFailDelay = 1000L;
    private static final int MAX_FAIL_DELAY = 300000;

    public AdminListener(RouterContext context, int port) {
        this._context = context;
        this._log = context.logManager().getLog(AdminListener.class);
        this._port = port;
        this._running = false;
    }

    public void restart() {
        this._nextFailDelay = 1000L;
        ServerSocket s = this._socket;
        try {
            this._socket = null;
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startup() {
        this._running = true;
        int curDelay = 0;
        while (this._running && curDelay < 300000) {
            try {
                this._log.info("Starting up listening for connections on port " + this._port);
                this._socket = new ServerSocket(this._port);
                curDelay = 0;
                while (this._running && this._socket != null) {
                    try {
                        Socket socket = this._socket.accept();
                        this._log.debug("Connection received");
                        this.runConnection(socket);
                    }
                    catch (IOException ioe) {
                        this._log.error("Server error accepting", (Throwable)ioe);
                    }
                    catch (Throwable t) {
                        this._log.error("Fatal error running client listener - killing the thread!", t);
                        return;
                    }
                }
            }
            catch (IOException ioe) {
                this._log.error("Error listening on port " + this._port, (Throwable)ioe);
            }
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this._socket = null;
            }
            this._log.error("Error listening, waiting " + this._nextFailDelay + "ms before we try again");
            try {
                Thread.sleep(this._nextFailDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            curDelay = (int)((long)curDelay + this._nextFailDelay);
            this._nextFailDelay *= 5L;
        }
        this._log.error("CANCELING ADMIN LISTENER.  delay = " + curDelay, (Throwable)new Exception("ADMIN LISTENER cancelled!!!"));
        this._running = false;
    }

    protected void runConnection(Socket socket) throws IOException {
        AdminRunner runner = new AdminRunner(this._context, socket);
        I2PThread t = new I2PThread((Runnable)runner);
        t.setName("Admin Runner");
        t.setDaemon(true);
        t.start();
    }

    public void shutdown() {
        this._running = false;
        if (this._socket != null) {
            try {
                this._socket.close();
                this._socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.startup();
    }
}

