/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.admin;

import java.io.Writer;
import net.i2p.router.RouterContext;
import net.i2p.router.Service;
import net.i2p.router.admin.AdminListener;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class AdminManager
implements Service {
    private Log _log;
    private RouterContext _context;
    public static final String PARAM_ADMIN_PORT = "router.adminPort";
    public static final int DEFAULT_ADMIN_PORT = 7655;
    private AdminListener _listener;

    public AdminManager(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(AdminManager.class);
    }

    public void renderStatusHTML(Writer out) {
    }

    public void shutdown() {
        if (this._listener != null) {
            this._log.info("Shutting down admin listener");
            this._listener.shutdown();
            this._listener = null;
        }
    }

    public void restart() {
        this.startup();
    }

    public void startup() {
        int port = 7655;
        String str = this._context.router().getConfigSetting(PARAM_ADMIN_PORT);
        if (str != null) {
            try {
                int val;
                port = val = Integer.parseInt(str);
                this._log.info("Starting up admin listener on port " + port);
            }
            catch (NumberFormatException nfe) {
                this._log.warn("Invalid admin port specified [" + str + "], using the default " + 7655, (Throwable)nfe);
            }
        } else {
            this._log.warn("Router admin port not specified, using the default 7655");
        }
        this.startup(port);
    }

    private void startup(int port) {
        if (this._listener == null) {
            this._listener = new AdminListener(this._context, port);
            I2PThread t = new I2PThread((Runnable)this._listener);
            t.setName("Admin Listener:" + port);
            t.setDaemon(true);
            t.start();
        } else {
            this._listener.setPort(port);
            this._listener.restart();
        }
    }
}

