/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.admin;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.admin.StatsGenerator;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class AdminRunner
implements Runnable {
    private Log _log;
    private RouterContext _context;
    private Socket _socket;
    private StatsGenerator _generator;
    private static final String SHUTDOWN_PASSWORD_PROP = "router.shutdownPassword";

    public AdminRunner(RouterContext context, Socket socket) {
        this._context = context;
        this._log = context.logManager().getLog(AdminRunner.class);
        this._socket = socket;
        this._generator = new StatsGenerator(context);
    }

    public void run() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
            OutputStream out = this._socket.getOutputStream();
            String command = in.readLine();
            this.runCommand(command, out);
        }
        catch (IOException ioe) {
            this._log.error("Error running admin command", (Throwable)ioe);
        }
    }

    private void runCommand(String command, OutputStream out) throws IOException {
        this._log.debug("Command [" + command + "]");
        if (command.indexOf("favicon") >= 0) {
            this.reply(out, "this is not a website");
        } else {
            if (command.indexOf("routerStats.html") >= 0 || command.indexOf("oldstats.jsp") >= 0) {
                try {
                    out.write("HTTP/1.1 200 OK\nConnection: close\nCache-control: no-cache\nContent-type: text/html\n\n".getBytes());
                    this._generator.generateStatsPage(new OutputStreamWriter(out));
                    out.close();
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error writing out the admin reply");
                    }
                    throw ioe;
                }
            }
            if (command.indexOf("/profile/") >= 0) {
                this.replyText(out, this.getProfile(command));
            } else if (command.indexOf("/shutdown") >= 0) {
                this.reply(out, this.shutdown(command));
            } else {
                try {
                    out.write("HTTP/1.1 200 OK\nConnection: close\nCache-control: no-cache\nContent-type: text/html\n\n".getBytes());
                    this._context.router().renderStatusHTML(new OutputStreamWriter(out));
                    out.close();
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Error writing out the admin reply");
                    }
                    throw ioe;
                }
            }
        }
    }

    private void reply(OutputStream out, String content) throws IOException {
        StringBuffer reply = new StringBuffer(10240);
        reply.append("HTTP/1.1 200 OK\n");
        reply.append("Connection: close\n");
        reply.append("Cache-control: no-cache\n");
        reply.append("Content-type: text/html\n\n");
        reply.append(content);
        try {
            out.write(reply.toString().getBytes());
            out.close();
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error writing out the admin reply:\n" + content);
            }
            throw ioe;
        }
    }

    private void replyText(OutputStream out, String content) throws IOException {
        StringBuffer reply = new StringBuffer(10240);
        reply.append("HTTP/1.1 200 OK\n");
        reply.append("Connection: close\n");
        reply.append("Cache-control: no-cache\n");
        reply.append("Content-type: text/plain\n\n");
        reply.append(content);
        try {
            out.write(reply.toString().getBytes());
            out.close();
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error writing out the admin reply:\n" + content);
            }
            throw ioe;
        }
    }

    private String getProfile(String cmd) {
        Set peers = this._context.profileOrganizer().selectAllPeers();
        for (Hash peer : peers) {
            if (cmd.indexOf(peer.toBase64().substring(0, 10)) < 0) continue;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
                this._context.profileOrganizer().exportProfile(peer, baos);
                return new String(baos.toByteArray());
            }
            catch (IOException ioe) {
                this._log.error("Error exporting the profile", (Throwable)ioe);
                return "Error exporting the peer profile\n";
            }
        }
        return "No such peer is being profiled\n";
    }

    private String shutdown(String cmd) {
        String password = this._context.router().getConfigSetting(SHUTDOWN_PASSWORD_PROP);
        if (password == null) {
            password = this._context.getProperty(SHUTDOWN_PASSWORD_PROP);
        }
        if (password == null) {
            return "No shutdown password specified in the config or context - <b>REFUSING SHUTDOWN</b>.<a href=\"/routerConsole.html\">back</a>";
        }
        if (cmd.indexOf(password) > 0) {
            I2PThread t = new I2PThread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AdminRunner.this._context.router().shutdown(3);
                }
            });
            t.start();
            return "Shutdown request accepted.  Killing the router in 30 seconds";
        }
        return "Incorrect shutdown password specified.  Please edit your router.config appropriately.<a href=\"/routerConsole.html\">back</a>";
    }
}

