/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.router.ClientManagerFacade;
import net.i2p.router.ClientMessage;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.ClientManager;
import net.i2p.util.Log;

public class ClientManagerFacadeImpl
extends ClientManagerFacade {
    private static final Log _log = new Log(ClientManagerFacadeImpl.class);
    private ClientManager _manager;
    private RouterContext _context;
    public static final String PROP_CLIENT_PORT = "i2cp.port";
    public static final int DEFAULT_PORT = 7654;
    public static final String PROP_CLIENT_HOST = "i2cp.hostname";
    public static final String DEFAULT_HOST = "127.0.0.1";
    private static final long MAX_TIME_TO_REBUILD = 600000L;

    public ClientManagerFacadeImpl(RouterContext context) {
        this._context = context;
        this._manager = null;
        _log.debug("Client manager facade created");
    }

    public void startup() {
        _log.info("Starting up the client subsystem");
        String portStr = this._context.router().getConfigSetting(PROP_CLIENT_PORT);
        if (portStr != null) {
            try {
                int port = Integer.parseInt(portStr);
                this._manager = new ClientManager(this._context, port);
            }
            catch (NumberFormatException nfe) {
                _log.error("Error setting the port: " + portStr + " is not valid", (Throwable)nfe);
                this._manager = new ClientManager(this._context, 7654);
            }
        } else {
            this._manager = new ClientManager(this._context, 7654);
        }
    }

    public void shutdown() {
        if (this._manager != null) {
            this._manager.shutdown();
        }
    }

    public void restart() {
        if (this._manager != null) {
            this._manager.restart();
        } else {
            this.startup();
        }
    }

    public boolean verifyClientLiveliness() {
        if (this._manager == null) {
            return true;
        }
        boolean lively = true;
        for (Destination dest : this._manager.getRunnerDestinations()) {
            long howLongAgo;
            LeaseSet ls;
            ClientConnectionRunner runner = this._manager.getRunner(dest);
            if (runner == null || runner.getIsDead() || (ls = runner.getLeaseSet()) == null || (howLongAgo = this._context.clock().now() - ls.getEarliestLeaseDate()) <= 600000L) continue;
            if (_log.shouldLog(40)) {
                _log.error("Client " + dest.calculateHash().toBase64().substring(0, 6) + " has a leaseSet that expired " + DataHelper.formatDuration((long)howLongAgo));
            }
            lively = false;
        }
        return lively;
    }

    public void requestLeaseSet(Destination dest, LeaseSet set, long timeout, Job onCreateJob, Job onFailedJob) {
        if (this._manager != null) {
            this._manager.requestLeaseSet(dest, set, timeout, onCreateJob, onFailedJob);
        } else {
            _log.error("Null manager on requestLeaseSet!");
        }
    }

    public void requestLeaseSet(Hash dest, LeaseSet set) {
        if (this._manager != null) {
            this._manager.requestLeaseSet(dest, set);
        }
    }

    public void reportAbuse(Destination dest, String reason, int severity) {
        if (this._manager != null) {
            this._manager.reportAbuse(dest, reason, severity);
        } else {
            _log.error("Null manager on reportAbuse!");
        }
    }

    public boolean isLocal(Destination dest) {
        if (this._manager != null) {
            return this._manager.isLocal(dest);
        }
        _log.debug("Null manager on isLocal(dest)!");
        return false;
    }

    public boolean isLocal(Hash destHash) {
        if (this._manager != null) {
            return this._manager.isLocal(destHash);
        }
        _log.debug("Null manager on isLocal(hash)!");
        return false;
    }

    public boolean shouldPublishLeaseSet(Hash destinationHash) {
        return this._manager.shouldPublishLeaseSet(destinationHash);
    }

    public void messageDeliveryStatusUpdate(Destination fromDest, MessageId id, boolean delivered) {
        if (this._manager != null) {
            this._manager.messageDeliveryStatusUpdate(fromDest, id, delivered);
        } else {
            _log.error("Null manager on messageDeliveryStatusUpdate!");
        }
    }

    public void messageReceived(ClientMessage msg) {
        if (this._manager != null) {
            this._manager.messageReceived(msg);
        } else {
            _log.error("Null manager on messageReceived!");
        }
    }

    public SessionConfig getClientSessionConfig(Destination dest) {
        if (this._manager != null) {
            return this._manager.getClientSessionConfig(dest);
        }
        _log.error("Null manager on getClientSessionConfig!");
        return null;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        if (this._manager != null) {
            this._manager.renderStatusHTML(out);
        }
    }

    public Set listClients() {
        if (this._manager != null) {
            return this._manager.listClients();
        }
        return Collections.EMPTY_SET;
    }
}

