/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.ArrayList;
import java.util.List;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class ClientWriterRunner
implements Runnable {
    private List _messagesToWrite;
    private List _messagesToWriteTimes;
    private ClientConnectionRunner _runner;
    private RouterContext _context;
    private Log _log;
    private long _id;
    private static long __id = 0L;
    private static final long MAX_WAIT = 5000L;
    private Object _dataLock = new Object();

    public ClientWriterRunner(RouterContext context, ClientConnectionRunner runner) {
        this._context = context;
        this._log = context.logManager().getLog(ClientWriterRunner.class);
        this._messagesToWrite = new ArrayList(4);
        this._messagesToWriteTimes = new ArrayList(4);
        this._runner = runner;
        this._id = ++__id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(I2CPMessage msg) {
        Object object = this._dataLock;
        synchronized (object) {
            this._messagesToWrite.add(msg);
            this._messagesToWriteTimes.add(new Long(this._context.clock().now()));
            this._dataLock.notifyAll();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("[" + this._id + "] addMessage completed for " + msg.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWriting() {
        Object object = this._dataLock;
        synchronized (object) {
            this._dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        List messages = new ArrayList(64);
        List messageTimes = new ArrayList(64);
        List switchList = null;
        while (!this._runner.getIsDead()) {
            Object object = this._dataLock;
            synchronized (object) {
                if (this._messagesToWrite.size() <= 0) {
                    try {
                        this._dataLock.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (this._messagesToWrite.size() > 0) {
                    switchList = this._messagesToWrite;
                    this._messagesToWrite = messages;
                    messages = switchList;
                    switchList = this._messagesToWriteTimes;
                    this._messagesToWriteTimes = messageTimes;
                    messageTimes = switchList;
                }
            }
            if (messages.size() > 0) {
                for (int i = 0; i < messages.size(); ++i) {
                    I2CPMessage msg = (I2CPMessage)messages.get(i);
                    Long when = (Long)messageTimes.get(i);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("[" + this._id + "] writeMessage before writing " + msg.getClass().getName());
                    }
                    this._runner.writeMessage(msg);
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("[" + this._id + "] writeMessage time since addMessage(): " + (this._context.clock().now() - when) + " for " + msg.getClass().getName());
                }
            }
            messages.clear();
            messageTimes.clear();
        }
    }
}

