/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.data.Base64;
import net.i2p.data.Certificate;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.ClientMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.OutboundClientMessageJobHelper;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.util.Log;

public class OutboundClientMessageOneShotJob
extends JobImpl {
    private Log _log;
    private long _overallExpiration;
    private ClientMessage _clientMessage;
    private MessageId _clientMessageId;
    private int _clientMessageSize;
    private Destination _from;
    private Destination _to;
    private String _toString;
    private LeaseSet _leaseSet;
    private Lease _lease;
    private PayloadGarlicConfig _clove;
    private long _cloveId;
    private long _start;
    private boolean _finished;
    private long _leaseSetLookupBegin;
    private TunnelInfo _outTunnel;
    private TunnelInfo _inTunnel;
    public static final String OVERALL_TIMEOUT_MS_PARAM = "clientMessageTimeout";
    private static final long OVERALL_TIMEOUT_MS_DEFAULT = 60000L;
    private static final int SEND_PRIORITY = 500;
    public static final String BUNDLE_REPLY_LEASESET = "shouldBundleReplyInfo";
    public static final String BUNDLE_PROBABILITY = "bundleReplyInfoProbability";
    private static final int BUNDLE_PROBABILITY_DEFAULT = 100;
    private static HashMap _leaseSetCache = new HashMap();
    private static long _lscleanTime = 0L;
    private static HashMap _leaseCache = new HashMap();
    private static long _lcleanTime = 0L;
    private String _hashPair;
    private static HashMap _tunnelCache = new HashMap();
    private static HashMap _backloggedTunnelCache = new HashMap();
    private static long _cleanTime = 0L;

    public OutboundClientMessageOneShotJob(RouterContext ctx, ClientMessage msg) {
        super(ctx);
        this._log = ctx.logManager().getLog(OutboundClientMessageOneShotJob.class);
        ctx.statManager().createFrequencyStat("client.sendMessageFailFrequency", "How often does a client fail to send a message?", "ClientMessages", new long[]{60000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.sendMessageSize", "How large are messages sent by the client?", "ClientMessages", new long[]{60000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.sendAckTime", "Message round trip time", "ClientMessages", new long[]{60000L, 300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionTunnel", "How lagged our tunnels are when a send times out?", "ClientMessages", new long[]{60000L, 300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionMessage", "How fast we process messages locally when a send times out?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionInbound", "How much faster we are receiving data than our average bps when a send times out?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.leaseSetFoundLocally", "How often we tried to look for a leaseSet and found it locally?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.leaseSetFoundRemoteTime", "How long we tried to look for a remote leaseSet (when we succeeded)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.leaseSetFailedRemoteTime", "How long we tried to look for a remote leaseSet (when we failed)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchPrepareTime", "How long until we've queued up the dispatch job (since we started)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchTime", "How long until we've dispatched the message (since we started)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchSendTime", "How long the actual dispatching takes?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchNoTunnels", "How long after start do we run out of tunnels to send/receive with?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchNoACK", "Repeated message sends to a peer (no ack required)", "ClientMessages", new long[]{60000L, 300000L, 3600000L});
        long timeoutMs = 60000L;
        this._clientMessage = msg;
        this._clientMessageId = msg.getMessageId();
        this._clientMessageSize = msg.getPayload().getSize();
        this._from = msg.getFromDestination();
        this._to = msg.getDestination();
        this._toString = this._to.calculateHash().toBase64().substring(0, 4);
        this._leaseSetLookupBegin = -1L;
        String param = msg.getSenderConfig().getOptions().getProperty(OVERALL_TIMEOUT_MS_PARAM);
        if (param == null) {
            param = ctx.router().getConfigSetting(OVERALL_TIMEOUT_MS_PARAM);
        }
        if (param != null) {
            try {
                timeoutMs = Long.parseLong(param);
            }
            catch (NumberFormatException nfe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Invalid client message timeout specified [" + param + "], defaulting to " + 60000L, (Throwable)nfe);
                }
                timeoutMs = 60000L;
            }
        }
        this._start = this.getContext().clock().now();
        this._overallExpiration = timeoutMs + this._start;
        this._finished = false;
    }

    public String getName() {
        return "Outbound client message";
    }

    public void runJob() {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Send outbound client message job beginning");
        }
        long timeoutMs = this._overallExpiration - this.getContext().clock().now();
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": preparing to search for the leaseSet for " + this._toString);
        }
        Hash key = this._to.calculateHash();
        SendJob success = new SendJob(this.getContext());
        LookupLeaseSetFailedJob failed = new LookupLeaseSetFailedJob(this.getContext());
        LeaseSet ls = this.getContext().netDb().lookupLeaseSetLocally(key);
        if (ls != null) {
            this.getContext().statManager().addRateData("client.leaseSetFoundLocally", 1L, 0L);
            this._leaseSetLookupBegin = -1L;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Send outbound client message - leaseSet found locally for " + this._toString);
            }
            success.runJob();
        } else {
            this._leaseSetLookupBegin = this.getContext().clock().now();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Send outbound client message - sending off leaseSet lookup job for " + this._toString);
            }
            this.getContext().netDb().lookupLeaseSet(key, success, failed, timeoutMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeaseSet getReplyLeaseSet(boolean force) {
        Properties opts;
        String wantBundle;
        LeaseSet newLS = this.getContext().netDb().lookupLeaseSetLocally(this._from.calculateHash());
        if (newLS == null) {
            return null;
        }
        if (!force && "true".equals(wantBundle = (opts = this._clientMessage.getSenderConfig().getOptions()).getProperty(BUNDLE_REPLY_LEASESET, "false"))) {
            int probability;
            block17: {
                probability = 100;
                String str = opts.getProperty(BUNDLE_PROBABILITY);
                try {
                    if (str != null) {
                        probability = Integer.parseInt(str);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!this._log.shouldLog(30)) break block17;
                    this._log.warn(this.getJobId() + ": Bundle leaseSet probability overridden incorrectly [" + str + "]", (Throwable)nfe);
                }
            }
            if (probability >= 100) {
                return newLS;
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Bundle leaseSet probability is " + probability);
            }
            if (probability >= this.getContext().random().nextInt(100)) {
                force = true;
            }
        }
        long now = this.getContext().clock().now();
        HashMap hashMap = _leaseSetCache;
        synchronized (hashMap) {
            LeaseSet ls;
            if (now - _lscleanTime > 300000L) {
                this.cleanLeaseSetCache(_leaseSetCache);
                _lscleanTime = now;
            }
            if (!force && (ls = (LeaseSet)_leaseSetCache.get(this.hashPair())) != null) {
                if (ls.equals((Object)newLS)) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Found in cache - NOT including reply leaseset for " + this._toString);
                    }
                    return null;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Expired from cache - reply leaseset for " + this._toString);
                }
            }
            _leaseSetCache.put(this.hashPair(), newLS);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Added to cache - reply leaseset for " + this._toString);
        }
        return newLS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getNextLease() {
        Lease lease;
        int i;
        this._leaseSet = this.getContext().netDb().lookupLeaseSetLocally(this._to.calculateHash());
        if (this._leaseSet == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Lookup locally didn't find the leaseSet for " + this._toString);
            }
            return false;
        }
        long now = this.getContext().clock().now();
        HashMap hashMap = _leaseCache;
        synchronized (hashMap) {
            if (now - _lcleanTime > 300000L) {
                this.cleanLeaseCache(_leaseCache);
                _lcleanTime = now;
            }
            this._lease = (Lease)_leaseCache.get(this.hashPair());
            if (this._lease != null) {
                if (!this._lease.isExpired(60000L)) {
                    for (i = 0; i < this._leaseSet.getLeaseCount(); ++i) {
                        lease = this._leaseSet.getLease(i);
                        if (!this._lease.equals((Object)lease)) continue;
                        if (this._log.shouldLog(20)) {
                            this._log.info("Found in cache - lease for " + this._toString);
                        }
                        return true;
                    }
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Expired from cache - lease for " + this._toString);
                }
                _leaseCache.remove(this._to);
            }
        }
        ArrayList<Lease> leases = new ArrayList<Lease>(this._leaseSet.getLeaseCount());
        for (i = 0; i < this._leaseSet.getLeaseCount(); ++i) {
            lease = this._leaseSet.getLease(i);
            if (lease.isExpired(60000L)) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info(this.getJobId() + ": getNextLease() - expired lease! - " + lease + " for " + this._toString);
                continue;
            }
            leases.add(lease);
        }
        if (leases.size() <= 0) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": No leases found from: " + this._leaseSet);
            }
            return false;
        }
        Collections.shuffle(leases);
        for (i = 0; i < leases.size(); ++i) {
            Lease l = (Lease)leases.get(i);
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(l.getGateway());
            if (ri == null || ri.getCapabilities().indexOf(85) < 0) {
                this._lease = l;
                break;
            }
            if (!this._log.shouldLog(30)) continue;
            this._log.warn(this.getJobId() + ": Skipping unreachable gateway " + l.getGateway() + " for " + this._toString);
        }
        if (this._lease == null) {
            this._lease = (Lease)leases.get(0);
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": All leases are unreachable for " + this._toString);
            }
        }
        HashMap hashMap2 = _leaseCache;
        synchronized (hashMap2) {
            _leaseCache.put(this.hashPair(), this._lease);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Added to cache - lease for " + this._toString);
        }
        return true;
    }

    private void send() {
        boolean ok;
        long token;
        if (this._finished) {
            return;
        }
        if (this.getContext().clock().now() >= this._overallExpiration) {
            this.dieFatal();
            return;
        }
        boolean wantACK = true;
        int existingTags = GarlicMessageBuilder.estimateAvailableTags(this.getContext(), this._leaseSet.getEncryptionKey());
        if (existingTags > 30 && this.getContext().random().nextInt(100) >= 5) {
            wantACK = false;
        }
        PublicKey key = this._leaseSet.getEncryptionKey();
        SessionKey sessKey = new SessionKey();
        HashSet tags = new HashSet();
        LeaseSet replyLeaseSet = this.getReplyLeaseSet(wantACK);
        if (replyLeaseSet != null) {
            wantACK = true;
        }
        long l = token = wantACK ? this.getContext().random().nextLong(0xFFFFFFFFL) : -1L;
        if (wantACK) {
            this._inTunnel = this.selectInboundTunnel();
        }
        boolean bl = ok = this._clientMessage != null && this.buildClove();
        if (!ok) {
            this.dieFatal();
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Clove built to " + this._toString);
        }
        long msgExpiration = this._overallExpiration;
        GarlicMessage msg = OutboundClientMessageJobHelper.createGarlicMessage(this.getContext(), token, msgExpiration, key, this._clove, this._from.calculateHash(), this._to, this._inTunnel, sessKey, tags, wantACK, replyLeaseSet);
        if (msg == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Unable to create the garlic message (no tunnels left or too lagged) to " + this._toString);
            }
            this.getContext().statManager().addRateData("client.dispatchNoTunnels", this.getContext().clock().now() - this._start, 0L);
            this.dieFatal();
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": send() - token expected " + token + " to " + this._toString);
        }
        SendSuccessJob onReply = null;
        SendTimeoutJob onFail = null;
        ReplySelector selector = null;
        if (wantACK) {
            onReply = new SendSuccessJob(this.getContext(), sessKey, tags);
            onFail = new SendTimeoutJob(this.getContext());
            selector = new ReplySelector(token);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Placing GarlicMessage into the new tunnel message bound for " + this._toString + " at " + this._lease.getTunnelId() + " on " + this._lease.getGateway().toBase64());
        }
        this._outTunnel = this.selectOutboundTunnel(this._to);
        if (this._outTunnel != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Sending tunnel message out " + this._outTunnel.getSendTunnelId(0) + " to " + this._toString + " at " + this._lease.getTunnelId() + " on " + this._lease.getGateway().toBase64());
            }
            DispatchJob dispatchJob = new DispatchJob(this.getContext(), msg, selector, onReply, onFail, (int)(this._overallExpiration - this.getContext().clock().now()));
            dispatchJob.runJob();
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Could not find any outbound tunnels to send the payload through... this might take a while");
            }
            this.getContext().statManager().addRateData("client.dispatchNoTunnels", this.getContext().clock().now() - this._start, 0L);
            this.dieFatal();
        }
        this._clientMessage = null;
        this._clove = null;
        this.getContext().statManager().addRateData("client.dispatchPrepareTime", this.getContext().clock().now() - this._start, 0L);
        if (!wantACK) {
            this.getContext().statManager().addRateData("client.dispatchNoACK", 1L, 0L);
        }
    }

    private String hashPair() {
        if (this._hashPair == null) {
            this._hashPair = this._to.calculateHash().toBase64() + this._from.calculateHash().toBase64();
        }
        return this._hashPair;
    }

    private Hash sourceFromHashPair(String s) {
        return new Hash(Base64.decode((String)s.substring(44, 88)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaches() {
        HashMap hashMap;
        String key = this.hashPair();
        if (this._inTunnel != null) {
            hashMap = _leaseSetCache;
            synchronized (hashMap) {
                _leaseSetCache.remove(key);
            }
        }
        if (this._lease != null) {
            hashMap = _leaseCache;
            synchronized (hashMap) {
                Lease l = (Lease)_leaseCache.get(key);
                if (l != null && l.equals((Object)this._lease)) {
                    _leaseCache.remove(key);
                }
            }
        }
        if (this._outTunnel != null) {
            hashMap = _tunnelCache;
            synchronized (hashMap) {
                TunnelInfo t = (TunnelInfo)_backloggedTunnelCache.get(key);
                if (t != null && t.equals(this._outTunnel)) {
                    _backloggedTunnelCache.remove(key);
                }
                if ((t = (TunnelInfo)_tunnelCache.get(key)) != null && t.equals(this._outTunnel)) {
                    _tunnelCache.remove(key);
                }
            }
        }
    }

    private void cleanLeaseSetCache(HashMap tc) {
        long now = this.getContext().clock().now();
        ArrayList<String> deleteList = new ArrayList<String>();
        for (Map.Entry entry : tc.entrySet()) {
            String k = (String)entry.getKey();
            LeaseSet l = (LeaseSet)entry.getValue();
            if (l.getEarliestLeaseDate() >= now) continue;
            deleteList.add(k);
        }
        for (String k : deleteList) {
            tc.remove(k);
        }
    }

    private void cleanLeaseCache(HashMap tc) {
        ArrayList<String> deleteList = new ArrayList<String>();
        for (Map.Entry entry : tc.entrySet()) {
            String k = (String)entry.getKey();
            Lease l = (Lease)entry.getValue();
            if (!l.isExpired(60000L)) continue;
            deleteList.add(k);
        }
        for (String k : deleteList) {
            tc.remove(k);
        }
    }

    private void cleanTunnelCache(HashMap tc) {
        ArrayList<String> deleteList = new ArrayList<String>();
        for (Map.Entry entry : tc.entrySet()) {
            String k = (String)entry.getKey();
            TunnelInfo tunnel = (TunnelInfo)entry.getValue();
            if (this.getContext().tunnelManager().isValidTunnel(this.sourceFromHashPair(k), tunnel)) continue;
            deleteList.add(k);
        }
        for (String k : deleteList) {
            tc.remove(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TunnelInfo selectOutboundTunnel(Destination to) {
        TunnelInfo tunnel;
        long now = this.getContext().clock().now();
        HashMap hashMap = _tunnelCache;
        synchronized (hashMap) {
            if (now - _cleanTime > 300000L) {
                this.cleanTunnelCache(_tunnelCache);
                this.cleanTunnelCache(_backloggedTunnelCache);
                _cleanTime = now;
            }
            if ((tunnel = (TunnelInfo)_backloggedTunnelCache.get(this.hashPair())) != null) {
                if (this.getContext().tunnelManager().isValidTunnel(this._from.calculateHash(), tunnel)) {
                    if (!this.getContext().commSystem().isBacklogged(tunnel.getPeer(1))) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Switching back to tunnel " + tunnel + " for " + this._toString);
                        }
                        _backloggedTunnelCache.remove(this.hashPair());
                        _tunnelCache.put(this.hashPair(), tunnel);
                        return tunnel;
                    }
                } else {
                    _backloggedTunnelCache.remove(this.hashPair());
                }
            }
            if ((tunnel = (TunnelInfo)_tunnelCache.get(this.hashPair())) != null) {
                if (this.getContext().tunnelManager().isValidTunnel(this._from.calculateHash(), tunnel)) {
                    if (tunnel.getLength() <= 1 || !this.getContext().commSystem().isBacklogged(tunnel.getPeer(1))) {
                        return tunnel;
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Switching from backlogged " + tunnel + " for " + this._toString);
                    }
                    _backloggedTunnelCache.put(this.hashPair(), tunnel);
                }
                _tunnelCache.remove(this.hashPair());
            }
            if ((tunnel = this.selectOutboundTunnel()) != null) {
                _tunnelCache.put(this.hashPair(), tunnel);
            }
        }
        return tunnel;
    }

    private TunnelInfo selectOutboundTunnel() {
        return this.getContext().tunnelManager().selectOutboundTunnel(this._from.calculateHash());
    }

    private TunnelInfo selectInboundTunnel() {
        return this.getContext().tunnelManager().selectInboundTunnel(this._from.calculateHash());
    }

    private void dieFatal() {
        if (this._finished) {
            return;
        }
        this._finished = true;
        long sendTime = this.getContext().clock().now() - this._start;
        if (this._log.shouldLog(30)) {
            this._log.warn(this.getJobId() + ": Failed to send the message " + this._clientMessageId + " to " + this._toString + " out " + this._outTunnel + " in " + this._lease + " ack " + this._inTunnel + " after " + sendTime + "ms");
        }
        long messageDelay = this.getContext().throttle().getMessageDelay();
        long tunnelLag = this.getContext().throttle().getTunnelLag();
        long inboundDelta = (long)this.getContext().throttle().getInboundRateDelta();
        this.getContext().statManager().addRateData("client.timeoutCongestionTunnel", tunnelLag, 1L);
        this.getContext().statManager().addRateData("client.timeoutCongestionMessage", messageDelay, 1L);
        this.getContext().statManager().addRateData("client.timeoutCongestionInbound", inboundDelta, 1L);
        this.clearCaches();
        this.getContext().messageHistory().sendPayloadMessage(this._clientMessageId.getMessageId(), false, sendTime);
        this.getContext().clientManager().messageDeliveryStatusUpdate(this._from, this._clientMessageId, false);
        this.getContext().statManager().updateFrequency("client.sendMessageFailFrequency");
        this._clientMessage = null;
        this._clove = null;
    }

    private boolean buildClove() {
        PayloadGarlicConfig clove = new PayloadGarlicConfig();
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(1);
        instructions.setDestination(this._to.calculateHash());
        instructions.setDelayRequested(false);
        instructions.setDelaySeconds(0L);
        instructions.setEncrypted(false);
        clove.setCertificate(new Certificate(0, null));
        clove.setDeliveryInstructions(instructions);
        clove.setExpiration(60000L + this.getContext().clock().now());
        clove.setId(this.getContext().random().nextLong(0xFFFFFFFFL));
        DataMessage msg = new DataMessage(this.getContext());
        Payload p = this._clientMessage.getPayload();
        if (p == null) {
            return false;
        }
        byte[] d = p.getEncryptedData();
        if (d == null) {
            return false;
        }
        msg.setData(d);
        msg.setMessageExpiration(clove.getExpiration());
        clove.setPayload(msg);
        clove.setRecipientPublicKey(null);
        clove.setRequestAck(false);
        this._clove = clove;
        this._cloveId = this._clove.getId();
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Built payload clove with id " + clove.getId());
        }
        return true;
    }

    private class SendTimeoutJob
    extends JobImpl {
        public SendTimeoutJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public String getName() {
            return "Send client message timed out";
        }

        public void runJob() {
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(10)) {
                OutboundClientMessageOneShotJob.this._log.debug(OutboundClientMessageOneShotJob.this.getJobId() + ": Soft timeout through the lease " + OutboundClientMessageOneShotJob.this._lease);
            }
            OutboundClientMessageOneShotJob.this._lease.setNumFailure(OutboundClientMessageOneShotJob.this._lease.getNumFailure() + 1);
            OutboundClientMessageOneShotJob.this.dieFatal();
        }
    }

    private class SendSuccessJob
    extends JobImpl
    implements ReplyJob {
        private SessionKey _key;
        private Set _tags;

        public SendSuccessJob(RouterContext enclosingContext, SessionKey key, Set tags) {
            super(enclosingContext);
            this._key = key;
            this._tags = tags;
        }

        public String getName() {
            return "Send client message successful";
        }

        public void runJob() {
            int i;
            if (OutboundClientMessageOneShotJob.this._finished) {
                return;
            }
            OutboundClientMessageOneShotJob.this._finished = true;
            long sendTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._start;
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": SUCCESS!  msg " + OutboundClientMessageOneShotJob.this._clientMessageId + " sent after " + sendTime + "ms");
            }
            if (this._key != null && this._tags != null && this._tags.size() > 0 && OutboundClientMessageOneShotJob.this._leaseSet != null) {
                this.getContext().sessionKeyManager().tagsDelivered(OutboundClientMessageOneShotJob.this._leaseSet.getEncryptionKey(), this._key, this._tags);
            }
            long dataMsgId = OutboundClientMessageOneShotJob.this._cloveId;
            this.getContext().messageHistory().sendPayloadMessage(dataMsgId, true, sendTime);
            this.getContext().clientManager().messageDeliveryStatusUpdate(OutboundClientMessageOneShotJob.this._from, OutboundClientMessageOneShotJob.this._clientMessageId, true);
            OutboundClientMessageOneShotJob.this._lease.setNumSuccess(OutboundClientMessageOneShotJob.this._lease.getNumSuccess() + 1);
            int size = OutboundClientMessageOneShotJob.this._clientMessageSize;
            this.getContext().statManager().addRateData("client.sendAckTime", sendTime, 0L);
            this.getContext().statManager().addRateData("client.sendMessageSize", (long)OutboundClientMessageOneShotJob.this._clientMessageSize, sendTime);
            if (OutboundClientMessageOneShotJob.this._outTunnel != null) {
                if (OutboundClientMessageOneShotJob.this._outTunnel.getLength() > 0) {
                    size = (size + 1023) / 1024 * 1024;
                }
                for (i = 0; i < OutboundClientMessageOneShotJob.this._outTunnel.getLength(); ++i) {
                    this.getContext().profileManager().tunnelTestSucceeded(OutboundClientMessageOneShotJob.this._outTunnel.getPeer(i), sendTime);
                    this.getContext().profileManager().tunnelDataPushed(OutboundClientMessageOneShotJob.this._outTunnel.getPeer(i), sendTime, size);
                }
                OutboundClientMessageOneShotJob.this._outTunnel.incrementVerifiedBytesTransferred(size);
            }
            if (OutboundClientMessageOneShotJob.this._inTunnel != null) {
                for (i = 0; i < OutboundClientMessageOneShotJob.this._inTunnel.getLength(); ++i) {
                    this.getContext().profileManager().tunnelTestSucceeded(OutboundClientMessageOneShotJob.this._inTunnel.getPeer(i), sendTime);
                }
            }
        }

        public void setMessage(I2NPMessage msg) {
        }
    }

    private class ReplySelector
    implements MessageSelector {
        private long _pendingToken;

        public ReplySelector(long token) {
            this._pendingToken = token;
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": Reply selector for client message: token=" + token);
            }
        }

        public boolean continueMatching() {
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(10)) {
                OutboundClientMessageOneShotJob.this._log.debug(OutboundClientMessageOneShotJob.this.getJobId() + ": dont continue matching for token=" + this._pendingToken);
            }
            return false;
        }

        public long getExpiration() {
            return OutboundClientMessageOneShotJob.this._overallExpiration;
        }

        public boolean isMatch(I2NPMessage inMsg) {
            if (inMsg.getType() == 10) {
                if (OutboundClientMessageOneShotJob.this._log.shouldLog(10)) {
                    OutboundClientMessageOneShotJob.this._log.debug(OutboundClientMessageOneShotJob.this.getJobId() + ": delivery status message received: " + inMsg + " our token: " + this._pendingToken);
                }
                return this._pendingToken == ((DeliveryStatusMessage)inMsg).getMessageId();
            }
            return false;
        }

        public String toString() {
            return "sending " + OutboundClientMessageOneShotJob.this._toString + " waiting for token " + this._pendingToken + " for cloveId " + OutboundClientMessageOneShotJob.this._cloveId;
        }
    }

    private class DispatchJob
    extends JobImpl {
        private GarlicMessage _msg;
        private ReplySelector _selector;
        private SendSuccessJob _replyFound;
        private SendTimeoutJob _replyTimeout;
        private int _timeoutMs;

        public DispatchJob(RouterContext ctx, GarlicMessage msg, ReplySelector sel, SendSuccessJob success, SendTimeoutJob timeout, int timeoutMs) {
            super(ctx);
            this._msg = msg;
            this._selector = sel;
            this._replyFound = success;
            this._replyTimeout = timeout;
            this._timeoutMs = timeoutMs;
        }

        public String getName() {
            return "Dispatch outbound client message";
        }

        public void runJob() {
            if (this._selector != null) {
                this.getContext().messageRegistry().registerPending(this._selector, this._replyFound, this._replyTimeout, this._timeoutMs);
            }
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                OutboundClientMessageOneShotJob.this._log.info("Dispatching message to " + OutboundClientMessageOneShotJob.this._toString + ": " + this._msg);
            }
            long before = this.getContext().clock().now();
            this.getContext().tunnelDispatcher().dispatchOutbound(this._msg, OutboundClientMessageOneShotJob.this._outTunnel.getSendTunnelId(0), OutboundClientMessageOneShotJob.this._lease.getTunnelId(), OutboundClientMessageOneShotJob.this._lease.getGateway());
            long dispatchSendTime = this.getContext().clock().now() - before;
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                OutboundClientMessageOneShotJob.this._log.info("Dispatching message to " + OutboundClientMessageOneShotJob.this._toString + " complete");
            }
            this.getContext().statManager().addRateData("client.dispatchTime", this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._start, 0L);
            this.getContext().statManager().addRateData("client.dispatchSendTime", dispatchSendTime, 0L);
        }
    }

    private class LookupLeaseSetFailedJob
    extends JobImpl {
        public LookupLeaseSetFailedJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public String getName() {
            return "Lookup for outbound client message failed";
        }

        public void runJob() {
            if (OutboundClientMessageOneShotJob.this._leaseSetLookupBegin > 0L) {
                long lookupTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._leaseSetLookupBegin;
                this.getContext().statManager().addRateData("client.leaseSetFailedRemoteTime", lookupTime, lookupTime);
            }
            if (!OutboundClientMessageOneShotJob.this._finished && OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                OutboundClientMessageOneShotJob.this._log.warn("Unable to send to " + OutboundClientMessageOneShotJob.this._toString + " because we couldn't find their leaseSet");
            }
            OutboundClientMessageOneShotJob.this.dieFatal();
        }
    }

    private class SendJob
    extends JobImpl {
        public SendJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public String getName() {
            return "Send outbound client message through the lease";
        }

        public void runJob() {
            boolean ok;
            if (OutboundClientMessageOneShotJob.this._leaseSetLookupBegin > 0L) {
                long lookupTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._leaseSetLookupBegin;
                this.getContext().statManager().addRateData("client.leaseSetFoundRemoteTime", lookupTime, lookupTime);
            }
            if (ok = OutboundClientMessageOneShotJob.this.getNextLease()) {
                OutboundClientMessageOneShotJob.this.send();
            } else {
                if (OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                    OutboundClientMessageOneShotJob.this._log.warn("Unable to send on a random lease, as getNext returned null (to=" + OutboundClientMessageOneShotJob.this._toString + ")");
                }
                OutboundClientMessageOneShotJob.this.dieFatal();
            }
        }
    }
}

