/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import net.i2p.data.Hash;
import net.i2p.data.RouterIdentity;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.HandleDatabaseLookupMessageJob;
import net.i2p.util.Log;

public class DatabaseLookupMessageHandler
implements HandlerJobBuilder {
    private RouterContext _context;
    private Log _log;

    public DatabaseLookupMessageHandler(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(DatabaseLookupMessageHandler.class);
        this._context.statManager().createRateStat("netDb.lookupsReceived", "How many netDb lookups have we received?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.lookupsDropped", "How many netDb lookups did we drop due to throttling?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
    }

    public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        this._context.statManager().addRateData("netDb.lookupsReceived", 1L, 0L);
        return new HandleDatabaseLookupMessageJob(this._context, (DatabaseLookupMessage)receivedMessage, from, fromHash);
    }
}

