/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class DataPublisherJob
extends JobImpl {
    private Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 120000L;
    private static final int MAX_SEND_PER_RUN = 1;
    private static final long STORE_TIMEOUT = 60000L;

    public DataPublisherJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(DataPublisherJob.class);
        this._facade = facade;
        this.getTiming().setStartAfter(ctx.clock().now() + 120000L);
    }

    public String getName() {
        return "Data Publisher Job";
    }

    public void runJob() {
        Set toSend = this.selectKeysToSend();
        if (this._log.shouldLog(20)) {
            this._log.info("Keys being published in this timeslice: " + toSend);
        }
        for (Hash key : toSend) {
            DataStructure data = this._facade.getDataStore().get(key);
            if (data == null) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Trying to send a key we dont have? " + key);
                continue;
            }
            if (data instanceof LeaseSet) {
                LeaseSet ls = (LeaseSet)data;
                if (!ls.isCurrent(60000L) && this._log.shouldLog(30)) {
                    this._log.warn("Not publishing a lease that isn't current - " + key, (Throwable)new Exception("Publish expired lease?"));
                }
                if (!this.getContext().clientManager().shouldPublishLeaseSet(key)) continue;
            }
            this._facade.sendStore(key, data, null, null, 60000L, null);
        }
        this.requeue(120000L);
    }

    private Set selectKeysToSend() {
        Set explicit = this._facade.getExplicitSendKeys();
        HashSet<Hash> toSend = new HashSet<Hash>(1);
        if (explicit.size() <= 0 && this.getContext().random().nextInt(10) > 0) {
            return toSend;
        }
        if (explicit.size() < 1) {
            toSend.addAll(explicit);
            this._facade.removeFromExplicitSend(explicit);
            Set passive = this._facade.getPassivelySendKeys();
            HashSet<Hash> psend = new HashSet<Hash>(passive.size());
            Iterator iter = passive.iterator();
            while (iter.hasNext() && toSend.size() < 1) {
                Hash key = (Hash)iter.next();
                toSend.add(key);
                psend.add(key);
            }
            this._facade.removeFromPassiveSend(psend);
        } else {
            Iterator iter = explicit.iterator();
            while (iter.hasNext() && toSend.size() < 1) {
                Hash key = (Hash)iter.next();
                toSend.add(key);
            }
            this._facade.removeFromExplicitSend(toSend);
        }
        return toSend;
    }
}

