/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class ExpireRoutersJob
extends JobImpl {
    private Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 120000L;
    public static final long EXPIRE_DELAY = 3600000L;

    public ExpireRoutersJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireRoutersJob.class);
        this._facade = facade;
    }

    public String getName() {
        return "Expire Routers Job";
    }

    public void runJob() {
        Set toExpire = this.selectKeysToExpire();
        this._log.info("Routers to expire (drop and try to refetch): " + toExpire);
        for (Hash key : toExpire) {
            this._facade.fail(key);
        }
        this._facade.queueForExploration(toExpire);
        this.requeue(120000L);
    }

    private Set selectKeysToExpire() {
        Set possible = this.getNotInUse();
        HashSet<Hash> expiring = new HashSet<Hash>(16);
        for (Hash key : possible) {
            RouterInfo ri = this._facade.lookupRouterInfoLocally(key);
            if (ri == null) continue;
            if (!ri.isCurrent(3600000L)) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Expiring RouterInfo for " + key.toBase64() + " [published on " + new Date(ri.getPublished()) + "]");
                }
                expiring.add(key);
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Not expiring routerInfo for " + key.toBase64() + " [published on " + new Date(ri.getPublished()) + "]");
        }
        return expiring;
    }

    private Set getNotInUse() {
        HashSet<Hash> possible = new HashSet<Hash>(16);
        for (Hash peer : this._facade.getAllRouters()) {
            if (!this.getContext().tunnelManager().isInUse(peer)) {
                possible.add(peer);
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Peer is in use: " + peer.toBase64());
        }
        return possible;
    }
}

