/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.util.Log;

class ExploreJob
extends SearchJob {
    private Log _log;
    private PeerSelector _peerSelector;
    private static final long MAX_EXPLORE_TIME = 10000L;
    private static final int NUM_CLOSEST_TO_IGNORE = 3;
    private static final int EXPLORE_BREDTH = 1;

    public ExploreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key) {
        super(context, facade, key, null, null, 10000L, false, false);
        this._log = context.logManager().getLog(ExploreJob.class);
        this._peerSelector = new PeerSelector(context);
    }

    protected DatabaseLookupMessage buildMessage(TunnelId replyTunnelId, RouterInfo replyGateway, long expiration) {
        DatabaseLookupMessage msg = new DatabaseLookupMessage(this.getContext(), true);
        msg.setSearchKey(this.getState().getTarget());
        msg.setFrom(replyGateway.getIdentity().getHash());
        msg.setDontIncludePeers(this.getState().getClosestAttempted(10));
        msg.setMessageExpiration(expiration);
        msg.setReplyTunnel(replyTunnelId);
        int available = 10 - msg.getDontIncludePeers().size();
        if (available > 0) {
            List peers = this._peerSelector.selectNearestExplicit(this.getState().getTarget(), available, msg.getDontIncludePeers(), this.getFacade().getKBuckets());
            msg.getDontIncludePeers().addAll(peers);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Peers we don't want to hear about: " + msg.getDontIncludePeers());
        }
        return msg;
    }

    protected DatabaseLookupMessage buildMessage(long expiration) {
        return this.buildMessage(null, this.getContext().router().getRouterInfo(), expiration);
    }

    protected int getBredth() {
        return 1;
    }

    protected void newPeersFound(int numNewPeers) {
        this._facade.setLastExploreNewDate(this.getContext().clock().now());
    }

    public String getName() {
        return "Kademlia NetDb Explore";
    }
}

