/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.util.Log;

class FloodLookupMatchJob
extends JobImpl
implements ReplyJob {
    private Log _log;
    private FloodSearchJob _search;

    public FloodLookupMatchJob(RouterContext ctx, FloodSearchJob job) {
        super(ctx);
        this._log = ctx.logManager().getLog(FloodLookupMatchJob.class);
        this._search = job;
    }

    public void runJob() {
        if (this.getContext().netDb().lookupLeaseSetLocally(this._search.getKey()) != null || this.getContext().netDb().lookupRouterInfoLocally(this._search.getKey()) != null) {
            this._search.success();
        } else {
            int remaining = this._search.getLookupsRemaining();
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + "/" + this._search.getJobId() + ": got a reply looking for " + this._search.getKey().toBase64() + ", with " + remaining + " outstanding searches");
            }
            if (remaining <= 0) {
                this._search.failed();
            }
        }
    }

    public String getName() {
        return "NetDb search (phase 1) match";
    }

    public void setMessage(I2NPMessage message) {
    }
}

