/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;

class FloodLookupSelector
implements MessageSelector {
    private RouterContext _context;
    private FloodSearchJob _search;

    public FloodLookupSelector(RouterContext ctx, FloodSearchJob search) {
        this._context = ctx;
        this._search = search;
    }

    public boolean continueMatching() {
        return this._search.getLookupsRemaining() > 0;
    }

    public long getExpiration() {
        return this._search.getExpiration();
    }

    public boolean isMatch(I2NPMessage message) {
        if (message == null) {
            return false;
        }
        if (message instanceof DatabaseStoreMessage) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
            if (this._search.getKey().equals((Object)dsm.getKey())) {
                this._search.decrementRemaining();
                return true;
            }
        } else if (message instanceof DatabaseSearchReplyMessage) {
            DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)message;
            if (this._search.getKey().equals((Object)dsrm.getSearchKey())) {
                this._search.decrementRemaining();
                return true;
            }
        }
        return false;
    }
}

