/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodLookupMatchJob;
import net.i2p.router.networkdb.kademlia.FloodLookupSelector;
import net.i2p.router.networkdb.kademlia.FloodLookupTimeoutJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;

class FloodSearchJob
extends JobImpl {
    private Log _log;
    private FloodfillNetworkDatabaseFacade _facade;
    private Hash _key;
    private List _onFind;
    private List _onFailed;
    private long _expiration;
    private int _timeoutMs;
    private long _origExpiration;
    private boolean _isLease;
    private volatile int _lookupsRemaining;
    private volatile boolean _dead;
    private static final int CONCURRENT_SEARCHES = 2;
    private static final int FLOOD_SEARCH_TIME_FACTOR = 2;
    private static final int FLOOD_SEARCH_TIME_MIN = 30000;

    public FloodSearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease) {
        super(ctx);
        this._log = ctx.logManager().getLog(FloodSearchJob.class);
        this._facade = facade;
        this._key = key;
        this._onFind = new ArrayList();
        this._onFind.add(onFind);
        this._onFailed = new ArrayList();
        this._onFailed.add(onFailed);
        int timeout = -1;
        timeout = timeoutMs / 2;
        if (timeout < timeoutMs) {
            timeout = timeoutMs;
        }
        this._timeoutMs = timeout;
        this._expiration = (long)timeout + ctx.clock().now();
        this._origExpiration = (long)timeoutMs + ctx.clock().now();
        this._isLease = isLease;
        this._lookupsRemaining = 0;
        this._dead = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeferred(Job onFind, Job onFailed, long timeoutMs, boolean isLease) {
        if (this._dead) {
            this.getContext().jobQueue().addJob(onFailed);
        } else {
            List list;
            if (onFind != null) {
                list = this._onFind;
                synchronized (list) {
                    this._onFind.add(onFind);
                }
            }
            if (onFailed != null) {
                list = this._onFailed;
                synchronized (list) {
                    this._onFailed.add(onFailed);
                }
            }
        }
    }

    public long getExpiration() {
        return this._expiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob() {
        List floodfillPeers = this._facade.getFloodfillPeers();
        FloodLookupSelector replySelector = new FloodLookupSelector(this.getContext(), this);
        FloodLookupMatchJob onReply = new FloodLookupMatchJob(this.getContext(), this);
        FloodLookupTimeoutJob onTimeout = new FloodLookupTimeoutJob(this.getContext(), this);
        OutNetMessage out = this.getContext().messageRegistry().registerPending(replySelector, onReply, onTimeout, this._timeoutMs);
        for (int i = 0; this._lookupsRemaining < 2 && i < floodfillPeers.size(); ++i) {
            Hash peer = (Hash)floodfillPeers.get(i);
            if (peer.equals((Object)this.getContext().routerHash())) continue;
            DatabaseLookupMessage dlm = new DatabaseLookupMessage(this.getContext(), true);
            TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundTunnel();
            TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundTunnel();
            if (replyTunnel == null || outTunnel == null) {
                this._dead = true;
                ArrayList removed = null;
                List list = this._onFailed;
                synchronized (list) {
                    removed = new ArrayList(this._onFailed);
                    this._onFailed.clear();
                }
                while (removed.size() > 0) {
                    this.getContext().jobQueue().addJob((Job)removed.remove(0));
                }
                this.getContext().messageRegistry().unregisterPending(out);
                return;
            }
            dlm.setFrom(replyTunnel.getPeer(0));
            dlm.setMessageExpiration(this.getContext().clock().now() + 10000L);
            dlm.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
            dlm.setSearchKey(this._key);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Floodfill search for " + this._key.toBase64() + " to " + peer.toBase64());
            }
            this.getContext().tunnelDispatcher().dispatchOutbound(dlm, outTunnel.getSendTunnelId(0), peer);
            ++this._lookupsRemaining;
        }
        if (this._lookupsRemaining <= 0) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Floodfill search for " + this._key.toBase64() + " had no peers to send to");
            }
            this.getContext().messageRegistry().unregisterPending(out);
            this._facade.searchFull(this._key, this._onFind, this._onFailed, this._timeoutMs * 2, this._isLease);
        }
    }

    public String getName() {
        return "NetDb search (phase 1)";
    }

    Hash getKey() {
        return this._key;
    }

    void decrementRemaining() {
        --this._lookupsRemaining;
    }

    int getLookupsRemaining() {
        return this._lookupsRemaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed() {
        if (this._dead) {
            return;
        }
        this._dead = true;
        int timeRemaining = (int)(this._origExpiration - this.getContext().clock().now());
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Floodfill search for " + this._key.toBase64() + " failed with " + timeRemaining);
        }
        if (timeRemaining > 0) {
            this._facade.searchFull(this._key, this._onFind, this._onFailed, timeRemaining, this._isLease);
        } else {
            ArrayList removed = null;
            List list = this._onFailed;
            synchronized (list) {
                removed = new ArrayList(this._onFailed);
                this._onFailed.clear();
            }
            while (removed.size() > 0) {
                this.getContext().jobQueue().addJob((Job)removed.remove(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void success() {
        if (this._dead) {
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Floodfill search for " + this._key.toBase64() + " successful");
        }
        this._dead = true;
        this._facade.complete(this._key);
        ArrayList removed = null;
        List list = this._onFind;
        synchronized (list) {
            removed = new ArrayList(this._onFind);
            this._onFind.clear();
        }
        while (removed.size() > 0) {
            this.getContext().jobQueue().addJob((Job)removed.remove(0));
        }
    }
}

