/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.util.Log;

public class FloodfillVerifyStoreJob
extends JobImpl {
    private Log _log;
    private Hash _key;
    private Hash _target;
    private FloodfillNetworkDatabaseFacade _facade;
    private long _expiration;
    private long _sendTime;
    private static final int VERIFY_TIMEOUT = 10000;

    public FloodfillVerifyStoreJob(RouterContext ctx, Hash key, FloodfillNetworkDatabaseFacade facade) {
        super(ctx);
        this._key = key;
        this._log = ctx.logManager().getLog(this.getClass());
        this._facade = facade;
        this.getTiming().setStartAfter(ctx.clock().now() + 10000L);
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyOK", "How long a floodfill verify takes when it succeeds", "NetworkDatabase", new long[]{60000L, 600000L, 3600000L});
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyFail", "How long a floodfill verify takes when it fails", "NetworkDatabase", new long[]{60000L, 600000L, 3600000L});
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyTimeout", "How long a floodfill verify takes when it times out", "NetworkDatabase", new long[]{60000L, 600000L, 3600000L});
    }

    public String getName() {
        return "Verify netdb store";
    }

    public void runJob() {
        this._target = this.pickTarget();
        if (this._target == null) {
            return;
        }
        DatabaseLookupMessage lookup = this.buildLookup();
        if (lookup == null) {
            return;
        }
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundTunnel();
        if (outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnels to verify a store");
            }
            return;
        }
        this._sendTime = this.getContext().clock().now();
        this._expiration = this._sendTime + 10000L;
        this.getContext().messageRegistry().registerPending(new VerifyReplySelector(), new VerifyReplyJob(this.getContext()), new VerifyTimeoutJob(this.getContext()), 10000);
        this.getContext().tunnelDispatcher().dispatchOutbound(lookup, outTunnel.getSendTunnelId(0), this._target);
    }

    private Hash pickTarget() {
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this._facade.getPeerSelector();
        List peers = sel.selectFloodfillParticipants(this._facade.getKBuckets());
        Collections.shuffle(peers, (Random)this.getContext().random());
        if (peers.size() > 0) {
            return (Hash)peers.get(0);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("No peers to verify floodfill with");
        }
        return null;
    }

    private DatabaseLookupMessage buildLookup() {
        TunnelInfo replyTunnelInfo = this.getContext().tunnelManager().selectInboundTunnel();
        if (replyTunnelInfo == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No inbound tunnels to get a reply from!");
            }
            return null;
        }
        DatabaseLookupMessage m = new DatabaseLookupMessage(this.getContext(), true);
        m.setMessageExpiration(this.getContext().clock().now() + 10000L);
        m.setReplyTunnel(replyTunnelInfo.getReceiveTunnelId(0));
        m.setFrom(replyTunnelInfo.getPeer(0));
        m.setSearchKey(this._key);
        return m;
    }

    private void resend() {
        LeaseSet ds = null;
        ds = this._facade.lookupLeaseSetLocally(this._key);
        if (ds == null) {
            ds = this._facade.lookupRouterInfoLocally(this._key);
        }
        if (ds != null) {
            this._facade.sendStore(this._key, (DataStructure)ds, null, null, 10000L, null);
        }
    }

    private class VerifyTimeoutJob
    extends JobImpl {
        public VerifyTimeoutJob(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "Floodfill verification timeout";
        }

        public void runJob() {
            this.getContext().profileManager().dbLookupFailed(FloodfillVerifyStoreJob.this._target);
            this.getContext().statManager().addRateData("netDb.floodfillVerifyTimeout", this.getContext().clock().now() - FloodfillVerifyStoreJob.this._sendTime, 0L);
            FloodfillVerifyStoreJob.this.resend();
        }
    }

    private class VerifyReplyJob
    extends JobImpl
    implements ReplyJob {
        private I2NPMessage _message;

        public VerifyReplyJob(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "Handle floodfill verification reply";
        }

        public void runJob() {
            long delay = this.getContext().clock().now() - FloodfillVerifyStoreJob.this._sendTime;
            if (this._message instanceof DatabaseStoreMessage) {
                this.getContext().profileManager().dbLookupSuccessful(FloodfillVerifyStoreJob.this._target, delay);
                this.getContext().statManager().addRateData("netDb.floodfillVerifyOK", delay, 0L);
            } else {
                if (this._message instanceof DatabaseSearchReplyMessage) {
                    this.getContext().profileManager().dbLookupReply(FloodfillVerifyStoreJob.this._target, 0, ((DatabaseSearchReplyMessage)this._message).getNumReplies(), 0, 0, delay);
                }
                this.getContext().statManager().addRateData("netDb.floodfillVerifyFail", delay, 0L);
                FloodfillVerifyStoreJob.this.resend();
            }
        }

        public void setMessage(I2NPMessage message) {
            this._message = message;
        }
    }

    private class VerifyReplySelector
    implements MessageSelector {
        private VerifyReplySelector() {
        }

        public boolean continueMatching() {
            return false;
        }

        public long getExpiration() {
            return FloodfillVerifyStoreJob.this._expiration;
        }

        public boolean isMatch(I2NPMessage message) {
            if (message instanceof DatabaseStoreMessage) {
                DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
                return FloodfillVerifyStoreJob.this._key.equals((Object)dsm.getKey());
            }
            if (message instanceof DatabaseSearchReplyMessage) {
                DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)message;
                return FloodfillVerifyStoreJob.this._key.equals((Object)dsrm.getSearchKey());
            }
            return false;
        }
    }
}

