/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.HandleDatabaseLookupMessageJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;

public class HandleFloodfillDatabaseLookupMessageJob
extends HandleDatabaseLookupMessageJob {
    public HandleFloodfillDatabaseLookupMessageJob(RouterContext ctx, DatabaseLookupMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        super(ctx, receivedMessage, from, fromHash);
    }

    protected boolean answerAllQueries() {
        if (!FloodfillNetworkDatabaseFacade.floodfillEnabled(this.getContext())) {
            return false;
        }
        return FloodfillNetworkDatabaseFacade.isFloodfill(this.getContext().router().getRouterInfo());
    }

    protected void sendClosest(Hash key, Set routerInfoSet, Hash toPeer, TunnelId replyTunnel) {
        super.sendClosest(key, routerInfoSet, toPeer, replyTunnel);
        if (!FloodfillNetworkDatabaseFacade.floodfillEnabled(this.getContext())) {
            DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
            RouterInfo me = this.getContext().router().getRouterInfo();
            msg.setKey(me.getIdentity().getHash());
            msg.setRouterInfo(me);
            msg.setValueType(0);
            this.sendMessage(msg, toPeer, replyTunnel);
        }
    }
}

