/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.TransientDataStore;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class PersistentDataStore
extends TransientDataStore {
    private Log _log;
    private String _dbDir;
    private KademliaNetworkDatabaseFacade _facade;
    private Writer _writer;
    private static final int READ_DELAY = 60000;
    private static final String LEASESET_PREFIX = "leaseSet-";
    private static final String LEASESET_SUFFIX = ".dat";
    private static final String ROUTERINFO_PREFIX = "routerInfo-";
    private static final String ROUTERINFO_SUFFIX = ".dat";

    public PersistentDataStore(RouterContext ctx, String dbDir, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(PersistentDataStore.class);
        this._dbDir = dbDir;
        this._facade = facade;
        this._context.jobQueue().addJob(new ReadJob());
        ctx.statManager().createRateStat("netDb.writeClobber", "How often we clobber a pending netDb write", "NetworkDatabase", new long[]{60000L, 600000L});
        ctx.statManager().createRateStat("netDb.writePending", "How many pending writes are there", "NetworkDatabase", new long[]{60000L, 600000L});
        this._writer = new Writer();
        I2PThread writer = new I2PThread((Runnable)this._writer, "DBWriter");
        writer.setDaemon(true);
        writer.start();
    }

    public void restart() {
        this._dbDir = this._facade.getDbDir();
    }

    public DataStructure remove(Hash key) {
        this._context.jobQueue().addJob(new RemoveJob(key));
        return super.remove(key);
    }

    public DataStructure removeLease(Hash key) {
        return super.removeLease(key);
    }

    public void put(Hash key, DataStructure data) {
        if (data == null || key == null) {
            return;
        }
        super.put(key, data);
        if (data instanceof RouterInfo) {
            this._writer.queue(key, data);
        }
    }

    private void accept(LeaseSet ls) {
        super.put(ls.getDestination().calculateHash(), (DataStructure)ls);
    }

    private void accept(RouterInfo ri) {
        Hash key = ri.getIdentity().getHash();
        super.put(key, (DataStructure)ri);
        this._facade.getKBuckets().add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Hash key, DataStructure data) {
        if (this._log.shouldLog(20)) {
            this._log.info("Writing key " + key);
        }
        FileOutputStream fos = null;
        File dbFile = null;
        try {
            String filename = null;
            File dbDir = this.getDbDir();
            if (data instanceof LeaseSet) {
                filename = this.getLeaseSetName(key);
            } else if (data instanceof RouterInfo) {
                filename = this.getRouterInfoName(key);
            } else {
                throw new IOException("We don't know how to write objects of type " + data.getClass().getName());
            }
            dbFile = new File(dbDir, filename);
            long dataPublishDate = this.getPublishDate(data);
            if (dbFile.lastModified() < dataPublishDate) {
                fos = new FileOutputStream(dbFile);
                try {
                    data.writeBytes((OutputStream)fos);
                    fos.close();
                    dbFile.setLastModified(dataPublishDate);
                }
                catch (DataFormatException dfe) {
                    this._log.error("Error writing out malformed object as " + key + ": " + data, (Throwable)dfe);
                    dbFile.delete();
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Not writing " + key.toBase64() + ", as its up to date on disk (file mod-publish=" + (dbFile.lastModified() - dataPublishDate) + ")");
            }
        }
        catch (IOException ioe) {
            this._log.error("Error writing out the object", (Throwable)ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private long getPublishDate(DataStructure data) {
        if (data instanceof RouterInfo) {
            return ((RouterInfo)data).getPublished();
        }
        if (data instanceof LeaseSet) {
            return ((LeaseSet)data).getEarliestLeaseDate();
        }
        return -1L;
    }

    private File getDbDir() throws IOException {
        boolean created;
        File f = new File(this._dbDir);
        if (!f.exists() && !(created = f.mkdirs())) {
            throw new IOException("Unable to create the DB directory [" + f.getAbsolutePath() + "]");
        }
        if (!f.isDirectory()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not a directory!");
        }
        if (!f.canRead()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not readable!");
        }
        if (!f.canWrite()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not writable!");
        }
        return f;
    }

    private String getLeaseSetName(Hash hash) {
        return LEASESET_PREFIX + hash.toBase64() + ".dat";
    }

    private String getRouterInfoName(Hash hash) {
        return ROUTERINFO_PREFIX + hash.toBase64() + ".dat";
    }

    private Hash getLeaseSetHash(String filename) {
        return this.getHash(filename, LEASESET_PREFIX, ".dat");
    }

    private Hash getRouterInfoHash(String filename) {
        return this.getHash(filename, ROUTERINFO_PREFIX, ".dat");
    }

    private Hash getHash(String filename, String prefix, String suffix) {
        try {
            String key = filename.substring(prefix.length());
            key = key.substring(0, key.length() - suffix.length());
            Hash h = new Hash();
            h.fromBase64(key);
            return h;
        }
        catch (Exception e) {
            this._log.warn("Unable to fetch the key from [" + filename + "]", (Throwable)e);
            return null;
        }
    }

    private void removeFile(Hash key, File dir) throws IOException {
        String riName = this.getRouterInfoName(key);
        File f = new File(dir, riName);
        if (f.exists()) {
            boolean removed = f.delete();
            if (!removed) {
                this._log.warn("Unable to remove router info at " + f.getAbsolutePath());
            } else {
                this._log.info("Removed router info at " + f.getAbsolutePath());
            }
            return;
        }
    }

    private static final class RouterInfoFilter
    implements FilenameFilter {
        private static final FilenameFilter _instance = new RouterInfoFilter();

        private RouterInfoFilter() {
        }

        public static final FilenameFilter getInstance() {
            return _instance;
        }

        public boolean accept(File dir, String name) {
            if (name == null) {
                return false;
            }
            return (name = name.toUpperCase()).startsWith(PersistentDataStore.ROUTERINFO_PREFIX.toUpperCase()) && name.endsWith(".dat".toUpperCase());
        }
    }

    private class ReadRouterJob
    extends JobImpl {
        private File _routerFile;
        private Hash _key;

        public ReadRouterJob(File routerFile, Hash key) {
            super(PersistentDataStore.this._context);
            this._routerFile = routerFile;
            this._key = key;
        }

        public String getName() {
            return "Read RouterInfo";
        }

        private boolean shouldRead() {
            DataStructure data = PersistentDataStore.this.get(this._key);
            if (data == null) {
                return true;
            }
            if (data instanceof RouterInfo) {
                long knownDate = ((RouterInfo)data).getPublished();
                long fileDate = this._routerFile.lastModified();
                return fileDate > knownDate;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJob() {
            block23: {
                if (!this.shouldRead()) {
                    return;
                }
                try {
                    FileInputStream fis = null;
                    boolean corrupt = false;
                    try {
                        fis = new FileInputStream(this._routerFile);
                        RouterInfo ri = new RouterInfo();
                        ri.readBytes((InputStream)fis);
                        if (ri.getNetworkId() != 2) {
                            corrupt = true;
                            if (PersistentDataStore.this._log.shouldLog(40)) {
                                PersistentDataStore.this._log.error("The router " + ri.getIdentity().calculateHash().toBase64() + " is from a different network");
                            }
                        } else {
                            try {
                                PersistentDataStore.this._facade.store(ri.getIdentity().getHash(), ri);
                            }
                            catch (IllegalArgumentException iae) {
                                PersistentDataStore.this._log.info("Refused locally loaded routerInfo - deleting");
                                corrupt = true;
                            }
                        }
                    }
                    catch (DataFormatException dfe) {
                        if (PersistentDataStore.this._log.shouldLog(20)) {
                            PersistentDataStore.this._log.info("Error reading the routerInfo from " + this._routerFile.getName(), (Throwable)dfe);
                        }
                        corrupt = true;
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (corrupt) {
                        this._routerFile.delete();
                    }
                }
                catch (IOException ioe) {
                    if (!PersistentDataStore.this._log.shouldLog(20)) break block23;
                    PersistentDataStore.this._log.info("Unable to read the router reference in " + this._routerFile.getName(), (Throwable)ioe);
                }
            }
        }
    }

    private class ReadJob
    extends JobImpl {
        private boolean _alreadyWarned;

        public ReadJob() {
            super(PersistentDataStore.this._context);
            this._alreadyWarned = false;
        }

        public String getName() {
            return "DB Read Job";
        }

        public void runJob() {
            PersistentDataStore.this._log.info("Rereading new files");
            this.readFiles();
            this.requeue(60000L);
        }

        private void readFiles() {
            int routerCount = 0;
            try {
                File dbDir = PersistentDataStore.this.getDbDir();
                File[] routerInfoFiles = dbDir.listFiles(RouterInfoFilter.getInstance());
                if (routerInfoFiles != null) {
                    routerCount += routerInfoFiles.length;
                    if (routerInfoFiles.length > 5) {
                        this._alreadyWarned = false;
                    }
                    for (int i = 0; i < routerInfoFiles.length; ++i) {
                        Hash key = PersistentDataStore.this.getRouterInfoHash(routerInfoFiles[i].getName());
                        if (key == null || PersistentDataStore.this.isKnown(key)) continue;
                        PersistentDataStore.this._context.jobQueue().addJob(new ReadRouterJob(routerInfoFiles[i], key));
                    }
                }
            }
            catch (IOException ioe) {
                PersistentDataStore.this._log.error("Error reading files in the db dir", (Throwable)ioe);
            }
            if (routerCount <= 5 && !this._alreadyWarned) {
                PersistentDataStore.this._log.error("Very few routerInfo files remaining - please reseed");
                this._alreadyWarned = true;
            }
        }
    }

    private class Writer
    implements Runnable {
        private Map _keys = new HashMap(64);
        private List _keyOrder = new ArrayList(64);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queue(Hash key, DataStructure data) {
            boolean exists = false;
            int pending = 0;
            Map map = this._keys;
            synchronized (map) {
                pending = this._keys.size();
                boolean bl = exists = null != this._keys.put(key, data);
                if (!exists) {
                    this._keyOrder.add(key);
                }
                this._keys.notifyAll();
            }
            if (exists) {
                PersistentDataStore.this._context.statManager().addRateData("netDb.writeClobber", (long)pending, 0L);
            }
            PersistentDataStore.this._context.statManager().addRateData("netDb.writePending", (long)pending, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Hash key = null;
            DataStructure data = null;
            int count = 0;
            while (true) {
                try {
                    Map map = this._keys;
                    synchronized (map) {
                        if (this._keyOrder.size() <= 0) {
                            count = 0;
                            this._keys.wait();
                        } else {
                            ++count;
                            key = (Hash)this._keyOrder.remove(0);
                            data = (DataStructure)this._keys.remove(key);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (key != null && data != null) {
                    PersistentDataStore.this.write(key, data);
                }
                key = null;
                data = null;
                if (count >= 600) {
                    count = 0;
                }
                if (count != 0) continue;
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException ie) {
                }
            }
        }
    }

    private class RemoveJob
    extends JobImpl {
        private Hash _key;

        public RemoveJob(Hash key) {
            super(PersistentDataStore.this._context);
            this._key = key;
        }

        public String getName() {
            return "Remove Key";
        }

        public void runJob() {
            PersistentDataStore.this._log.info("Removing key " + this._key);
            try {
                File dbDir = PersistentDataStore.this.getDbDir();
                PersistentDataStore.this.removeFile(this._key, dbDir);
            }
            catch (IOException ioe) {
                PersistentDataStore.this._log.error("Error removing key " + this._key, (Throwable)ioe);
            }
        }
    }
}

