/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodOnlySearchJob;

class SingleSearchJob
extends FloodOnlySearchJob {
    Hash _to;
    OutNetMessage _onm;

    public SingleSearchJob(RouterContext ctx, Hash key, Hash to) {
        super(ctx, null, key, null, null, 5000, false);
        this._to = to;
    }

    public String getName() {
        return "NetDb search key from DSRM";
    }

    public boolean shouldProcessDSRM() {
        return false;
    }

    public void runJob() {
        this._onm = this.getContext().messageRegistry().registerPending(this._replySelector, this._onReply, this._onTimeout, this._timeoutMs);
        DatabaseLookupMessage dlm = new DatabaseLookupMessage(this.getContext(), true);
        TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundTunnel();
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundTunnel();
        if (replyTunnel == null || outTunnel == null) {
            this.failed();
            return;
        }
        dlm.setFrom(replyTunnel.getPeer(0));
        dlm.setMessageExpiration(this.getContext().clock().now() + 5000L);
        dlm.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
        dlm.setSearchKey(this._key);
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Single search for " + this._key.toBase64() + " to " + this._to.toBase64());
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(dlm, outTunnel.getSendTunnelId(0), this._to);
        this._lookupsRemaining = 1;
    }

    void failed() {
        this.getContext().messageRegistry().unregisterPending(this._onm);
    }

    void success() {
    }
}

