/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;

class StoreState {
    private RouterContext _context;
    private Hash _key;
    private DataStructure _data;
    private HashSet _pendingPeers;
    private HashMap _pendingPeerTimes;
    private HashSet _successfulPeers;
    private HashSet _successfulExploratoryPeers;
    private HashSet _failedPeers;
    private HashSet _attemptedPeers;
    private int _completeCount;
    private volatile long _completed;
    private volatile long _started;

    public StoreState(RouterContext ctx, Hash key, DataStructure data) {
        this(ctx, key, data, null);
    }

    public StoreState(RouterContext ctx, Hash key, DataStructure data, Set toSkip) {
        this._context = ctx;
        this._key = key;
        this._data = data;
        this._pendingPeers = new HashSet(16);
        this._pendingPeerTimes = new HashMap(16);
        this._attemptedPeers = new HashSet(16);
        if (toSkip != null) {
            this._attemptedPeers.addAll(toSkip);
            this._completeCount = toSkip.size();
        }
        this._failedPeers = new HashSet(16);
        this._successfulPeers = new HashSet(16);
        this._successfulExploratoryPeers = new HashSet(16);
        this._completed = -1L;
        this._started = this._context.clock().now();
    }

    public Hash getTarget() {
        return this._key;
    }

    public DataStructure getData() {
        return this._data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPending() {
        HashSet hashSet = this._pendingPeers;
        synchronized (hashSet) {
            return (Set)this._pendingPeers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAttempted() {
        HashSet hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            return (Set)this._attemptedPeers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSuccessful() {
        HashSet hashSet = this._successfulPeers;
        synchronized (hashSet) {
            return (Set)this._successfulPeers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSuccessfulExploratory() {
        HashSet hashSet = this._successfulExploratoryPeers;
        synchronized (hashSet) {
            return (Set)this._successfulExploratoryPeers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getFailed() {
        HashSet hashSet = this._failedPeers;
        synchronized (hashSet) {
            return (Set)this._failedPeers.clone();
        }
    }

    public boolean completed() {
        return this._completed != -1L;
    }

    public void complete(boolean completed) {
        if (completed && this._completed <= 0L) {
            this._completed = this._context.clock().now();
        }
    }

    public int getCompleteCount() {
        return this._completeCount;
    }

    public long getWhenStarted() {
        return this._started;
    }

    public long getWhenCompleted() {
        return this._completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Hash peer) {
        HashSet hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.add(peer);
            this._pendingPeerTimes.put(peer, new Long(this._context.clock().now()));
        }
        hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Collection pending) {
        HashSet hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.addAll(pending);
            Iterator iter = pending.iterator();
            while (iter.hasNext()) {
                this._pendingPeerTimes.put(iter.next(), new Long(this._context.clock().now()));
            }
        }
        hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.addAll(pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSkipped(Hash peer) {
        HashSet hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long confirmed(Hash peer) {
        long rv = -1L;
        HashSet hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
            Long when = (Long)this._pendingPeerTimes.remove(peer);
            if (when != null) {
                rv = this._context.clock().now() - when;
            }
        }
        hashSet = this._successfulPeers;
        synchronized (hashSet) {
            this._successfulPeers.add(peer);
        }
        ++this._completeCount;
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long confirmedExploratory(Hash peer) {
        long rv = -1L;
        HashSet hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
            Long when = (Long)this._pendingPeerTimes.remove(peer);
            if (when != null) {
                rv = this._context.clock().now() - when;
            }
        }
        hashSet = this._successfulExploratoryPeers;
        synchronized (hashSet) {
            this._successfulExploratoryPeers.add(peer);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyTimeout(Hash peer) {
        HashSet hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
        }
        hashSet = this._failedPeers;
        synchronized (hashSet) {
            this._failedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("Storing ").append(this._key);
        buf.append(" ");
        if (this._completed <= 0L) {
            buf.append(" completed? false ");
        } else {
            buf.append(" completed on ").append(new Date(this._completed));
        }
        buf.append(" Attempted: ");
        HashSet hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            buf.append(this._attemptedPeers.size()).append(' ');
            for (Hash peer : this._attemptedPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append(" Pending: ");
        hashSet = this._pendingPeers;
        synchronized (hashSet) {
            buf.append(this._pendingPeers.size()).append(' ');
            for (Hash peer : this._pendingPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append(" Failed: ");
        hashSet = this._failedPeers;
        synchronized (hashSet) {
            buf.append(this._failedPeers.size()).append(' ');
            for (Hash peer : this._failedPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append(" Successful: ");
        hashSet = this._successfulPeers;
        synchronized (hashSet) {
            buf.append(this._successfulPeers.size()).append(' ');
            for (Hash peer : this._successfulPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append(" Successful Exploratory: ");
        hashSet = this._successfulExploratoryPeers;
        synchronized (hashSet) {
            buf.append(this._successfulExploratoryPeers.size()).append(' ');
            for (Hash peer : this._successfulExploratoryPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        return buf.toString();
    }
}

