/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.Calculator;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class CapacityCalculator
extends Calculator {
    private Log _log;
    private RouterContext _context;
    static long GROWTH_FACTOR = 5L;
    private static long ESTIMATE_PERIOD = 3600000L;

    public CapacityCalculator(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(CapacityCalculator.class);
    }

    public double calc(PeerProfile profile) {
        RateStat acceptStat = profile.getTunnelCreateResponseTime();
        RateStat rejectStat = profile.getTunnelHistory().getRejectionRate();
        RateStat failedStat = profile.getTunnelHistory().getFailedRate();
        double capacity10m = this.estimateCapacity(acceptStat, rejectStat, failedStat, 600000);
        double capacity30m = this.estimateCapacity(acceptStat, rejectStat, failedStat, 1800000);
        double capacity60m = this.estimateCapacity(acceptStat, rejectStat, failedStat, 3600000);
        double capacity1d = this.estimateCapacity(acceptStat, rejectStat, failedStat, 86400000);
        double capacity = capacity10m * this.periodWeight(600000) + capacity30m * this.periodWeight(1800000) + capacity60m * this.periodWeight(3600000) + capacity1d * this.periodWeight(86400000);
        if (capacity10m <= 0.0) {
            capacity = 0.0;
        }
        if (this.tooOld(profile)) {
            capacity = 1.0;
        }
        long now = this._context.clock().now();
        if (profile.getTunnelHistory().getLastRejectedTransient() > now - 300000L) {
            capacity = 1.0;
        } else if (profile.getTunnelHistory().getLastRejectedProbabalistic() > now - 300000L) {
            capacity -= (double)this._context.random().nextInt(5);
        }
        capacity += (double)profile.getCapacityBonus();
        if (capacity < 0.0) {
            capacity = 0.0;
        }
        return capacity;
    }

    private boolean tooOld(PeerProfile profile) {
        return !profile.getIsActive(3600000L);
    }

    private double estimateCapacity(RateStat acceptStat, RateStat rejectStat, RateStat failedStat, int period) {
        Rate curAccepted = acceptStat.getRate((long)period);
        Rate curRejected = rejectStat.getRate((long)period);
        Rate curFailed = failedStat.getRate((long)period);
        long eventCount = 0L;
        if (curAccepted != null) {
            eventCount = curAccepted.getCurrentEventCount() + curAccepted.getLastEventCount();
        }
        if (eventCount > 0L) {
            long rejected = curRejected.getCurrentEventCount() + curRejected.getLastEventCount();
            eventCount = eventCount * eventCount / (eventCount + rejected);
        }
        double stretch = (double)ESTIMATE_PERIOD / (double)period;
        double val = (double)eventCount * stretch;
        long failed = 0L;
        if (curFailed != null) {
            failed = (long)(0.5 + 4.0 * (curFailed.getCurrentTotalValue() + curFailed.getLastTotalValue()) / 100.0);
        }
        if (failed > 0L) {
            val -= (double)failed * stretch;
        }
        if ((val += (double)GROWTH_FACTOR) >= 0.0) {
            return val;
        }
        return 0.0;
    }

    private double periodWeight(int period) {
        switch (period) {
            case 600000: {
                return 0.4;
            }
            case 1800000: {
                return 0.3;
            }
            case 3600000: {
                return 0.2;
            }
            case 86400000: {
                return 0.1;
            }
        }
        throw new IllegalArgumentException("wtf, period [" + period + "]???");
    }
}

